/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import java.util.List;
import java.util.Objects;
import java.util.function.ObjDoubleConsumer;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayCaster {
    public static void cast(Level world, Entity camera, Vec3 origin, Vec3 direction, double maxDistance, ObjDoubleConsumer<HitResult> results) {
        boolean showBlock = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK);
        boolean showFluid = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID);
        boolean showEntity = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY);
        Vec3 max = origin.add(direction.x * maxDistance, direction.y * maxDistance, direction.z * maxDistance);
        if (showBlock || showFluid) {
            BlockGetter.traverseBlocks((Vec3)origin, (Vec3)max, (Object)Unit.INSTANCE, (unit, pos) -> {
                VoxelShape fluidShape;
                BlockHitResult fluidHit;
                FluidState fluidState;
                BlockState blockState;
                if (showBlock && !(blockState = world.getBlockState(pos)).isAir()) {
                    VoxelShape blockShape = blockState.getShape((BlockGetter)world, pos);
                    BlockHitResult blockHit = world.clipWithInteractionOverride(origin, max, pos.immutable(), blockShape, blockState);
                    if (blockHit != null) {
                        results.accept((HitResult)blockHit, origin.distanceToSqr(blockHit.getLocation()));
                    }
                }
                if (showFluid && (fluidState = world.getFluidState(pos)).isSource() && (fluidHit = (fluidShape = fluidState.getShape((BlockGetter)world, pos)).clip(origin, max, pos.immutable())) != null) {
                    results.accept((HitResult)fluidHit, origin.distanceToSqr(fluidHit.getLocation()));
                }
                return null;
            }, unit -> unit);
        }
        if (showEntity) {
            List entities = world.getEntities(camera, new AABB(origin, max), EntitySelector.ENTITY_STILL_ALIVE);
            for (Entity entity : entities) {
                AABB bounds = entity.getBoundingBox();
                Vec3 clip = bounds.clip(origin, max).orElse(null);
                if (bounds.contains(origin)) {
                    clip = Objects.requireNonNullElse(clip, origin);
                }
                if (clip == null) continue;
                results.accept((HitResult)new EntityHitResult(entity, clip), origin.distanceToSqr(clip));
            }
        }
    }
}

