/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class ButtonEntry
extends ConfigListWidget.Entry {
    private Component title;
    private final Button button;

    public ButtonEntry(String title, Button button) {
        this(title, title, button);
    }

    public ButtonEntry(String name, String button, Button buttonWidget) {
        this.title = Component.translatable((String)name);
        this.button = buttonWidget;
        buttonWidget.setMessage((Component)Component.translatable((String)button));
    }

    public ButtonEntry(String title, int width, int height, Button.OnPress pressAction) {
        this(title, title, width, height, pressAction);
    }

    public ButtonEntry(String name, String button, int width, int height, Button.OnPress pressAction) {
        this(name, button, DisplayUtil.createButton(0, 0, width, height, (Component)Component.empty(), pressAction));
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    @Override
    protected void drawEntry(GuiGraphics ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        Font font = this.client.font;
        Objects.requireNonNull(this.client.font);
        ctx.drawString(font, this.title, rowLeft, rowTop + (height - 9) / 2, -1);
        this.button.setX(rowLeft + width - this.button.getWidth());
        this.button.setY(rowTop + (height - this.button.getHeight()) / 2);
        this.button.render(ctx, mouseX, mouseY, deltaTime);
    }

    @Override
    protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
        children.add((Object)this.button);
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        sb.append(this.title.getString());
    }
}

