/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network.common.s2c;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.config.ConfigPackets;
import lol.bai.badpackets.api.play.PlayPackets;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.Packet;
import mcp.mobius.waila.util.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class ConfigSyncCommonS2CPacket
implements Packet {
    private static final Log LOG = Log.create();
    private static final Gson GSON = new Gson();
    public static final CustomPacketPayload.Type<Payload> TYPE = new CustomPacketPayload.Type(Waila.id("config"));
    public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = StreamCodec.ofMember((p, buf) -> {
        Map<String, List<ResourceLocation>> groups = p.map.keySet().stream().collect(Collectors.groupingBy(ResourceLocation::getNamespace));
        buf.writeVarInt(groups.size());
        groups.forEach((namespace, entries) -> {
            buf.writeUtf(namespace);
            buf.writeVarInt(entries.size());
            entries.forEach(e -> {
                buf.writeUtf(e.getPath());
                Object v = p.map.get(e);
                if (v instanceof Boolean) {
                    Boolean z = (Boolean)v;
                    buf.writeByte(0);
                    buf.writeBoolean(z.booleanValue());
                } else if (v instanceof Integer) {
                    Integer i = (Integer)v;
                    buf.writeByte(1);
                    buf.writeVarInt(i.intValue());
                } else if (v instanceof Double) {
                    Double d = (Double)v;
                    buf.writeByte(2);
                    buf.writeDouble(d.doubleValue());
                } else if (v instanceof String) {
                    String str = (String)v;
                    buf.writeByte(3);
                    buf.writeUtf(str);
                } else if (v instanceof Enum) {
                    Enum en = (Enum)v;
                    buf.writeByte(3);
                    buf.writeUtf(en.name());
                }
            });
        });
    }, buf -> {
        HashMap<ResourceLocation, Object> map = new HashMap<ResourceLocation, Object>();
        int groupSize = buf.readVarInt();
        for (int i = 0; i < groupSize; ++i) {
            String namespace = buf.readUtf();
            int groupLen = buf.readVarInt();
            block7: for (int j = 0; j < groupLen; ++j) {
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)buf.readUtf());
                byte type = buf.readByte();
                switch (type) {
                    case 0: {
                        map.put(id, buf.readBoolean());
                        continue block7;
                    }
                    case 1: {
                        map.put(id, buf.readVarInt());
                        continue block7;
                    }
                    case 2: {
                        map.put(id, buf.readDouble());
                        continue block7;
                    }
                    case 3: {
                        map.put(id, buf.readUtf());
                    }
                }
            }
        }
        return new Payload(map);
    });

    @Override
    public void common() {
        ConfigPackets.registerClientChannel(TYPE, CODEC);
        PlayPackets.registerClientChannel(TYPE, CODEC);
    }

    @Override
    public void client() {
        ConfigPackets.registerClientReceiver(TYPE, (context, payload) -> ConfigSyncCommonS2CPacket.receive(payload));
        PlayPackets.registerClientReceiver(TYPE, (context, payload) -> ConfigSyncCommonS2CPacket.receive(payload));
    }

    private static void receive(Payload payload) {
        Map<ResourceLocation, Object> map = payload.map;
        for (ConfigEntry<Object> config : PluginConfig.getSyncableConfigs()) {
            ResourceLocation id = config.getId();
            Object clientOnlyValue = config.getClientOnlyValue();
            Object syncedValue = map.get(id);
            if (clientOnlyValue instanceof Enum) {
                Enum e = (Enum)clientOnlyValue;
                if (!(syncedValue instanceof Enum)) {
                    syncedValue = Enum.valueOf(e.getDeclaringClass(), (String)map.getOrDefault(id, e.name()));
                }
            }
            if (syncedValue instanceof Double) {
                Double d = (Double)syncedValue;
                if (clientOnlyValue instanceof Integer) {
                    syncedValue = d.intValue();
                }
            }
            config.setServerValue(syncedValue);
        }
        LOG.info("Received config from the server: {}", GSON.toJson(map));
    }

    public record Payload(Map<ResourceLocation, Object> map) implements CustomPacketPayload
    {
        public Payload() {
            this(PluginConfig.getSyncableConfigs().stream().filter(it -> it.getOrigin().isEnabled()).collect(Collectors.toMap(ConfigEntry::getId, ConfigEntry::getLocalValue)));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

