/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.access;

import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum DataReader implements IDataReader
{
    SERVER,
    CLIENT;

    public static final IDataReader NOOP;
    private CompoundTag raw;
    private final Map<Class<? extends IData>, IData> typed = new HashMap<Class<? extends IData>, IData>();
    private boolean clean;

    private DataReader() {
        this.reset(null);
    }

    public void reset(@Nullable CompoundTag raw) {
        if (this.clean && raw == null) {
            return;
        }
        this.raw = raw == null ? new CompoundTag() : raw;
        this.clean = raw == null;
        this.typed.clear();
    }

    public static IData readTypedPacket(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        IData.Serializer<?> serializer = Registrar.get().dataId2Serializer.get(id);
        return serializer.read(buf);
    }

    @Override
    public CompoundTag raw() {
        return this.raw;
    }

    @Override
    @Nullable
    public <T extends IData> T get(Class<T> type) {
        return (T)this.typed.get(type);
    }

    @Override
    public <T extends IData> void invalidate(Class<T> type) {
        this.typed.remove(type);
    }

    public void add(IData data) {
        this.clean = false;
        this.typed.put(Registrar.get().impl2ApiDataType.get(data.getClass()), data);
    }

    static {
        NOOP = new IDataReader(){
            private static final CompoundTag TAG = new CompoundTag();

            @Override
            public CompoundTag raw() {
                return TAG;
            }

            @Override
            @Nullable
            public <T extends IData> T get(Class<T> type) {
                return null;
            }

            @Override
            public <T extends IData> void invalidate(Class<T> type) {
            }
        };
    }
}

