/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api;

import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IClientApiService;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiSide.ClientOnly
@ApiStatus.NonExtendable
public interface IWailaConfig {
    public static IWailaConfig get() {
        return IClientApiService.INSTANCE.getConfig();
    }

    public General getGeneral();

    public Overlay getOverlay();

    public Formatter getFormatter();

    public static interface Formatter {
        public Component modName(Object var1);

        public Component blockName(Object var1);

        public Component fluidName(Object var1);

        public Component entityName(Object var1);

        public Component registryName(Object var1);
    }

    public static interface Overlay {
        public Position getPosition();

        public float getScale();

        public Color getColor();

        public static interface Color {
            public int getBackgroundAlpha();

            public ITheme getTheme();

            @Deprecated(forRemoval=true)
            @ApiStatus.ScheduledForRemoval(inVersion="1.20")
            public int getAlpha();

            @Deprecated(forRemoval=true)
            @ApiStatus.ScheduledForRemoval(inVersion="1.20")
            public int getBackgroundColor();

            @Deprecated(forRemoval=true)
            @ApiStatus.ScheduledForRemoval(inVersion="1.20")
            public int getGradientStart();

            @Deprecated(forRemoval=true)
            @ApiStatus.ScheduledForRemoval(inVersion="1.20")
            public int getGradientEnd();

            @Deprecated(forRemoval=true)
            @ApiStatus.ScheduledForRemoval(inVersion="1.20")
            public int getFontColor();
        }

        public static interface Position {
            public int getX();

            public int getY();

            public Align getAlign();

            public Align getAnchor();

            public boolean isBossBarsOverlap();

            public static interface Align {
                public X getX();

                public Y getY();

                public static enum Y {
                    TOP(0.0),
                    MIDDLE(0.5),
                    BOTTOM(1.0);

                    public final double multiplier;

                    private Y(double multiplier) {
                        this.multiplier = multiplier;
                    }
                }

                public static enum X {
                    LEFT(0.0),
                    CENTER(0.5),
                    RIGHT(1.0);

                    public final double multiplier;

                    private X(double multiplier) {
                        this.multiplier = multiplier;
                    }
                }
            }
        }
    }

    public static interface General {
        public boolean isDisplayTooltip();

        public boolean isShiftForDetails();

        public boolean isHideShiftText();

        public DisplayMode getDisplayMode();

        public boolean isHideFromPlayerList();

        public boolean isHideFromDebug();

        public boolean isEnableTextToSpeech();

        public int getRateLimit();

        @Deprecated(forRemoval=true)
        @ApiStatus.ScheduledForRemoval(inVersion="1.20")
        public int getMaxHealthForRender();

        @Deprecated(forRemoval=true)
        @ApiStatus.ScheduledForRemoval(inVersion="1.20")
        public int getMaxHeartsPerLine();

        public static enum DisplayMode {
            HOLD_KEY,
            TOGGLE;

        }
    }
}

