/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api;

import java.text.DecimalFormat;

public final class WailaHelper {
    private static final long[] DECIMALS = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final DecimalFormat SUFFIXED_FORMAT = new DecimalFormat("0.##");

    public static String suffix(long value) {
        if (value == Long.MIN_VALUE) {
            return WailaHelper.suffix(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + WailaHelper.suffix(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        int exponent = -1;
        long divisor = 0L;
        for (long decimal : DECIMALS) {
            if (value < decimal) break;
            ++exponent;
            divisor = decimal;
        }
        double truncated = (double)value / (double)divisor;
        if (truncated >= 100.0) {
            truncated = Math.round(truncated);
        } else if (truncated >= 10.0) {
            truncated = (double)Math.round(truncated * 10.0) / 10.0;
        }
        return SUFFIXED_FORMAT.format(truncated) + "KMGTPE".charAt(exponent);
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static double getLuminance(int rgb) {
        return (0.299 * (double)WailaHelper.getRed(rgb) + 0.587 * (double)WailaHelper.getGreen(rgb) + 0.114 * (double)WailaHelper.getBlue(rgb)) / 255.0;
    }

    private WailaHelper() {
        throw new UnsupportedOperationException();
    }
}

