/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IClientApiService;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

@ApiSide.ClientOnly
public class ItemListComponent
implements ITooltipComponent.HorizontalGrowing {
    private final List<ItemStack> items;
    private final int maxHeight;
    private final float scale;
    private int gridWidth;
    private int gridHeight;
    private int maxIndex;

    public ItemListComponent(List<ItemStack> items) {
        this(items, 3);
    }

    public ItemListComponent(List<ItemStack> items, int maxHeight) {
        this(items, maxHeight, 1.0f);
    }

    public ItemListComponent(List<ItemStack> items, int maxHeight, float scale) {
        this.items = items;
        this.maxHeight = maxHeight;
        this.scale = scale;
    }

    @Override
    public int getMinimalWidth() {
        return (int)((float)(Math.min(this.items.size(), 9) * 18) * this.scale);
    }

    @Override
    public void setGrownWidth(int grownWidth) {
        this.gridWidth = Mth.m_14167_((float)((float)grownWidth / (18.0f * this.scale)));
        this.gridHeight = this.items.isEmpty() ? 0 : Math.min(Mth.m_184652_((int)this.items.size(), (int)this.gridWidth), this.maxHeight);
        this.maxIndex = this.gridWidth * this.gridHeight - 1;
    }

    @Override
    public int getHeight() {
        return Mth.m_14167_((float)((float)(this.gridHeight * 18) * this.scale));
    }

    @Override
    public void render(PoseStack matrices, int x, int y, float delta) {
        PoseStack pose = RenderSystem.m_157191_();
        pose.m_85836_();
        pose.m_85837_((double)x, (double)y, 0.0);
        pose.m_85841_(this.scale, this.scale, 1.0f);
        RenderSystem.m_157182_();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = this.items.get(i);
            int ix = 18 * (i % this.gridWidth) + 1;
            int iy = 18 * (i / this.gridWidth) + 1;
            IClientApiService.INSTANCE.renderItem(ix, iy, item);
            if (i == this.maxIndex) break;
        }
        pose.m_85849_();
        RenderSystem.m_157182_();
    }
}

