/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T, C extends ConfigValue<T, C>>
extends ConfigListWidget.Entry {
    private final Map<Object, Consumer<C>> watchers = new HashMap<Object, Consumer<C>>();
    protected final Consumer<T> save;
    protected final String translationKey;
    @Nullable
    protected final T defaultValue;
    protected final T initialValue;
    private final MutableComponent title;
    private final String description;
    private final Button resetButton;
    @Nullable
    private String disabledReason = null;
    private boolean disabled = false;
    @Nullable
    private String id;
    private T value;
    private int x;

    public ConfigValue(String translationKey, T value, @Nullable T defaultValue, Consumer<T> save) {
        this.translationKey = translationKey;
        this.title = Component.m_237115_((String)translationKey);
        this.description = translationKey + "_desc";
        this.initialValue = value;
        this.value = value;
        this.save = save;
        this.defaultValue = defaultValue;
        this.resetButton = defaultValue == null ? null : new Button(0, 0, 40, 20, (Component)Component.m_237115_((String)"controls.reset"), button -> this.resetValue());
    }

    @Override
    protected void drawEntry(PoseStack matrices, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        MutableComponent title = this.getTitle();
        if (this.isDisabled()) {
            title.m_130944_(new ChatFormatting[]{ChatFormatting.STRIKETHROUGH, ChatFormatting.GRAY});
        } else if (!this.isValueValid()) {
            title.m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED});
        } else if (!this.value.equals(this.initialValue)) {
            title.m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
        } else {
            title.m_130940_(ChatFormatting.RESET);
        }
        Font font = this.client.f_91062_;
        MutableComponent mutableComponent = title.m_6881_();
        float f = rowLeft;
        float f2 = rowTop;
        Objects.requireNonNull(this.client.f_91062_);
        font.m_92763_(matrices, (Component)mutableComponent, f, f2 + (float)(height - 9) / 2.0f, 0xFFFFFF);
        int w = width;
        if (this.resetButton != null) {
            w -= this.resetButton.m_5711_() + 2;
            this.resetButton.f_93620_ = rowLeft + width - this.resetButton.m_5711_();
            this.resetButton.f_93621_ = rowTop + (height - this.resetButton.m_93694_()) / 2;
            this.resetButton.f_93623_ = !this.isValueValid() || !this.isDisabled() && !this.getValue().equals(this.defaultValue);
            this.resetButton.m_6305_(matrices, mouseX, mouseY, deltaTime);
        }
        this.drawValue(matrices, w, height, rowLeft, rowTop, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    @Override
    public void renderTooltip(Screen screen, PoseStack matrices, int mouseX, int mouseY, float delta) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            int x1 = widget.f_93620_ - 2;
            int y1 = widget.f_93621_;
            int x2 = widget.f_93620_ + widget.m_5711_() + 4;
            int y2 = widget.f_93621_ + widget.m_93694_() + 4;
            if (x1 > mouseX || mouseX > x2 || y1 > mouseY || mouseY > y2) continue;
            return;
        }
        Component desc = this.getDescription();
        if (this.id != null || desc != null || this.isDisabled() && this.disabledReason != null) {
            String string = this.getTitle().getString();
            ArrayList tooltip = Lists.newArrayList((Object[])new FormattedCharSequence[]{Component.m_237113_((String)string).m_7532_()});
            if (desc != null) {
                tooltip.addAll(this.client.f_91062_.m_92923_((FormattedText)desc, 250));
            }
            if (this.isDisabled() && this.disabledReason != null) {
                tooltip.addAll(this.client.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)this.disabledReason).m_130940_(ChatFormatting.RED), 250));
            }
            if (this.id != null) {
                tooltip.add(Component.m_237113_((String)this.id).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            }
            screen.m_96617_(matrices, (List)tooltip, mouseX, mouseY);
        }
    }

    public boolean isChanged() {
        if (!this.isValueValid()) {
            return true;
        }
        return !this.value.equals(this.initialValue);
    }

    public boolean isValueValid() {
        return true;
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        sb.append(this.getTitle().getString());
        Component desc = this.getDescription();
        if (desc != null) {
            sb.append(" ").append(desc.getString());
        }
    }

    @Override
    protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
        Button resetButton;
        GuiEventListener element = this.getListener();
        if (element != null) {
            children.add((Object)element);
        }
        if ((resetButton = this.getResetButton()) != null) {
            children.add((Object)resetButton);
        }
    }

    public void save() {
        if (!this.isDisabled()) {
            this.save.accept(this.getValue());
        }
    }

    @Nullable
    public GuiEventListener getListener() {
        return null;
    }

    @Nullable
    public Button getResetButton() {
        return this.resetButton;
    }

    public MutableComponent getTitle() {
        return this.title;
    }

    @Nullable
    public Component getDescription() {
        return I18n.m_118936_((String)this.description) ? Component.m_237115_((String)this.description).m_130940_(ChatFormatting.GRAY) : null;
    }

    public int getX() {
        return this.x;
    }

    @NotNull
    public final T getValue() {
        return this.value;
    }

    protected final void callWatchers() {
        this.watchers.values().forEach(w -> w.accept(this));
    }

    protected final void setValue(T value, boolean notify) {
        this.value = value;
        if (notify) {
            this.callWatchers();
        }
    }

    public void setValue(T value) {
        this.setValue(value, true);
    }

    protected void resetValue() {
        this.setValue(this.defaultValue);
    }

    public final void addWatcher(Object key, Consumer<C> watcher) {
        this.watchers.put(key, watcher);
        watcher.accept((C)((Object)this));
    }

    public void enable() {
        this.disabledReason = null;
        this.disabled = false;
    }

    public void disable(@Nullable String reason) {
        this.disabledReason = reason;
        this.disabled = true;
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    protected abstract void drawValue(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);
}

