/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.provider;

import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITargetRedirector;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.mixin.EntityAccess;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum EntityProvider implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    @Nullable
    public ITargetRedirector.Result redirect(ITargetRedirector redirect, IEntityAccessor accessor, IPluginConfig config) {
        if (IBlacklistConfig.get().contains((Entity)accessor.getEntity())) {
            return redirect.toBehind();
        }
        return null;
    }

    @Override
    @Nullable
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        if (entity instanceof Mob) {
            return null;
        }
        ItemStack stack = entity.m_142340_();
        return stack != null ? new ItemComponent(stack) : null;
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        Component customName = entity.m_7770_();
        Object name = customName != null ? customName.m_6881_().m_130946_(" (").m_7220_(((EntityAccess)entity).wthit_getTypeName()).m_130946_(")") : entity.m_7755_();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(name));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(Registry.f_122826_.m_7981_((Object)entity.m_6095_())));
        }
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(accessor.getEntity()).getName()));
        }
    }
}

