/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.IllegalFormatException;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;

public final class DisplayUtil
extends GuiComponent {
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.renderStack(x, y, stack, stack.m_41613_() > 1 ? WailaHelper.suffix(stack.m_41613_()) : "");
    }

    public static void renderStack(int x, int y, ItemStack stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.m_91291_().m_115123_(stack, x, y);
            CLIENT.m_91291_().m_115174_(DisplayUtil.CLIENT.f_91062_, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionUtil.dump(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void enable3DRender() {
        Lighting.m_84931_();
        RenderSystem.m_69482_();
    }

    public static void enable2DRender() {
        Lighting.m_84930_();
        RenderSystem.m_69465_();
    }

    public static void renderRectBorder(Matrix4f matrix, VertexConsumer buf, int x, int y, int w, int h, int s, int gradStart, int gradEnd) {
        if (s <= 0) {
            return;
        }
        DisplayUtil.fillGradient(matrix, buf, x, y, w, s, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x, y + h - s, w, s, gradEnd, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x, y + s, s, h - s * 2, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + w - s, y + s, s, h - s * 2, gradStart, gradEnd);
    }

    public static void fillGradient(Matrix4f matrix, VertexConsumer buf, int x, int y, int w, int h, int start, int end) {
        float sa = (float)FastColor.ARGB32.m_13655_((int)start) / 255.0f;
        float sr = (float)FastColor.ARGB32.m_13665_((int)start) / 255.0f;
        float sg = (float)FastColor.ARGB32.m_13667_((int)start) / 255.0f;
        float sb = (float)FastColor.ARGB32.m_13669_((int)start) / 255.0f;
        float ea = (float)FastColor.ARGB32.m_13655_((int)end) / 255.0f;
        float er = (float)FastColor.ARGB32.m_13665_((int)end) / 255.0f;
        float eg = (float)FastColor.ARGB32.m_13667_((int)end) / 255.0f;
        float eb = (float)FastColor.ARGB32.m_13669_((int)end) / 255.0f;
        buf.m_85982_(matrix, (float)x, (float)y, 0.0f).m_85950_(sr, sg, sb, sa).m_5752_();
        buf.m_85982_(matrix, (float)x, (float)(y + h), 0.0f).m_85950_(er, eg, eb, ea).m_5752_();
        buf.m_85982_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_85950_(er, eg, eb, ea).m_5752_();
        buf.m_85982_(matrix, (float)(x + w), (float)y, 0.0f).m_85950_(sr, sg, sb, sa).m_5752_();
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }
}

