/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.component.BarComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.api.data.EnergyData;
import mcp.mobius.waila.plugin.extra.data.EnergyDataImpl;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class EnergyProvider
extends DataProvider<EnergyData, EnergyDataImpl> {
    public static final EnergyProvider INSTANCE = new EnergyProvider();
    private static final String INFINITE = "\u221e";
    private static final class_2960 INFINITE_TAG_ID = new class_2960("waila", "extra/infinite_energy");
    private static final class_6862<class_2248> INFINITE_BLOCK_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)INFINITE_TAG_ID);
    private static final class_6862<class_2591<?>> INFINITE_BLOCK_ENTITY_TAG = class_6862.method_40092((class_5321)class_7924.field_41255, (class_2960)INFINITE_TAG_ID);
    private static final class_6862<class_1299<?>> INFINITE_ENTITY_TAG = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)INFINITE_TAG_ID);

    private EnergyProvider() {
        super(EnergyData.ID, EnergyData.class, EnergyDataImpl.class, EnergyDataImpl::new);
    }

    @Override
    protected void registerAdditions(ICommonRegistrar registrar, int priority) {
        registrar.blockData(new InfiniteEnergyBlockProvider(), class_2586.class, 1);
        registrar.entityData(new InfiniteEnergyEntityProvider(), class_1297.class, 1);
    }

    @Override
    protected void appendBody(ITooltip tooltip, EnergyDataImpl energy, IPluginConfig config, class_2960 objectId) {
        Object text;
        EnergyDataImpl.Description desc = EnergyDataImpl.Description.get(objectId.method_12836());
        double stored = energy.stored();
        double capacity = energy.capacity();
        float ratio = Double.isInfinite(capacity) ? 1.0f : (float)(stored / capacity);
        String unit = desc.unit();
        class_2561 name = desc.name();
        int color = desc.color();
        if (Double.isInfinite(stored)) {
            text = INFINITE;
        } else {
            text = WailaHelper.suffix((long)stored);
            if (Double.isFinite(capacity)) {
                text = (String)text + "/" + WailaHelper.suffix((long)capacity);
            }
        }
        if (!unit.isEmpty()) {
            text = (String)text + " " + unit;
        }
        tooltip.setLine(EnergyData.ID, new PairComponent(new WrappedComponent(name), new BarComponent(ratio, 0xFF000000 | color, (String)text)));
    }

    private static class InfiniteEnergyBlockProvider
    implements IDataProvider<class_2586> {
        private InfiniteEnergyBlockProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<class_2586> accessor, IPluginConfig config) {
            data.add(EnergyData.class, res -> {
                class_2586 target = (class_2586)accessor.getTarget();
                if (target.method_11010().method_26164(INFINITE_BLOCK_TAG) || class_7923.field_41181.method_47983((Object)target.method_11017()).method_40220(INFINITE_BLOCK_ENTITY_TAG)) {
                    res.add(EnergyData.INFINITE);
                }
            });
        }
    }

    private static class InfiniteEnergyEntityProvider
    implements IDataProvider<class_1297> {
        private InfiniteEnergyEntityProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<class_1297> accessor, IPluginConfig config) {
            data.add(EnergyData.class, res -> {
                if (((class_1297)accessor.getTarget()).method_5864().method_20210(INFINITE_ENTITY_TAG)) {
                    res.add(EnergyData.INFINITE);
                }
            });
        }
    }
}

