/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.awt.Rectangle;
import java.util.Objects;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.mixed.MMultiPlayerGameMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public enum BreakProgressProvider implements IEventListener
{
    INSTANCE;

    static final int FADE_TICK = 3;
    boolean wasBreaking = false;
    float targetProgress = 0.0f;
    float lastProgress = 0.0f;
    boolean fadeFinish = false;
    int fadeTicks = 0;
    float fade = 0.0f;

    @Override
    public void onTick(IPluginConfig config) {
        boolean isBreaking;
        this.targetProgress = 0.0f;
        if (this.fadeFinish) {
            this.fade = 0.0f;
            this.lastProgress = 0.0f;
            this.fadeFinish = false;
        }
        if (!config.getBoolean(Options.BREAKING_PROGRESS)) {
            return;
        }
        MMultiPlayerGameMode gameMode = (MMultiPlayerGameMode)Objects.requireNonNull(class_310.method_1551().field_1761);
        this.targetProgress = gameMode.wthit_destroyProgress();
        boolean bl = isBreaking = this.targetProgress > 0.0f;
        if (this.wasBreaking && !isBreaking) {
            this.fadeTicks = 3;
            this.fade = this.fadeTicks;
            if (gameMode.wthit_wasDestroyed()) {
                this.targetProgress = 1.0f;
            }
        }
        this.wasBreaking = isBreaking;
        if (this.fadeTicks > 0) {
            --this.fadeTicks;
            if (this.fadeTicks == 0) {
                this.fadeFinish = true;
            }
        }
    }

    @Override
    public void onAfterTooltipRender(class_332 ctx, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        float lineLength;
        float dt = class_310.method_1551().method_1534();
        float progress = this.lastProgress;
        if (this.targetProgress > this.lastProgress) {
            float progressChange = (this.targetProgress - this.lastProgress) * dt;
            progress = class_3532.method_15363((float)(this.lastProgress + progressChange), (float)0.0f, (float)1.0f);
        }
        this.lastProgress = progress;
        if (progress <= 0.0f && this.fade <= 0.0f) {
            return;
        }
        boolean bottomOnly = config.getBoolean(Options.BREAKING_PROGRESS_BOTTOM_ONLY);
        float f = lineLength = bottomOnly ? (float)(rect.width - 2) * progress : (float)((rect.width - 2 + (rect.height - 2)) * 2) * progress;
        if (lineLength > 0.0f) {
            int hLength = rect.width - 2;
            int vLength = rect.height - 4;
            int x = rect.x + 1;
            int y = rect.y + rect.height - 2;
            int color = config.getInt(Options.BREAKING_PROGRESS_COLOR);
            float alpha = this.fade > 0.0f ? this.fade / 3.0f : 1.0f;
            int a = (int)(alpha * (float)(color >> 24 & 0xFF));
            color = color & 0xFFFFFF | a << 24;
            this.fill(ctx, x, y, (float)x + Math.min(lineLength, (float)hLength), y + 1, color);
            lineLength -= (float)hLength;
            if (lineLength > 0.0f) {
                x = rect.x + rect.width - 2;
                y = rect.y + rect.height - 2;
                this.fill(ctx, x, y, x + 1, (float)y - Math.min(lineLength, (float)vLength), color);
                lineLength -= (float)vLength;
                if (lineLength > 0.0f) {
                    x = rect.x + rect.width - 1;
                    y = rect.y + 1;
                    this.fill(ctx, x, y, (float)x - Math.min(lineLength, (float)hLength), y + 1, color);
                    lineLength -= (float)hLength;
                    if (lineLength > 0.0f) {
                        x = rect.x + 1;
                        y = rect.y + 2;
                        this.fill(ctx, x, y, x + 1, (float)y + Math.min(lineLength, (float)vLength), color);
                    }
                }
            }
            ctx.method_51452();
        }
        if (this.fade > 0.0f) {
            this.fade = Math.max(this.fade - dt, 0.0f);
        }
    }

    private void fill(class_332 ctx, float x1, float y1, float x2, float y2, int color) {
        float o;
        Matrix4f matrix4f = ctx.method_51448().method_23760().method_23761();
        if (x1 < x2) {
            o = x1;
            x1 = x2;
            x2 = o;
        }
        if (y1 < y2) {
            o = y1;
            y1 = y2;
            y2 = o;
        }
        class_4588 vertexConsumer = ctx.method_51450().getBuffer(class_1921.method_51784());
        vertexConsumer.method_22918(matrix4f, x1, y1, 0.0f).method_39415(color).method_1344();
        vertexConsumer.method_22918(matrix4f, x1, y2, 0.0f).method_39415(color).method_1344();
        vertexConsumer.method_22918(matrix4f, x2, y2, 0.0f).method_39415(color).method_1344();
        vertexConsumer.method_22918(matrix4f, x2, y1, 0.0f).method_39415(color).method_1344();
    }
}

