/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

@ApiSide.ClientOnly
public class HealthComponent
implements ITooltipComponent {
    private final int health;
    private final int iconCount;
    private final int lineWidth;
    private final boolean absorption;

    public HealthComponent(float health, float maxHealth, int maxPerLine, boolean absorption) {
        this.health = Mth.m_14167_((float)health);
        this.iconCount = Mth.m_184652_((int)Mth.m_14167_((float)Math.max(health, maxHealth)), (int)2);
        this.lineWidth = Math.min(this.iconCount, maxPerLine);
        this.absorption = absorption;
    }

    @Override
    public int getWidth() {
        return this.lineWidth * 8 + 1;
    }

    @Override
    public int getHeight() {
        return Mth.m_184652_((int)this.iconCount, (int)this.lineWidth) * 3 + 6;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, float delta) {
        int filled = this.health / 2 - 1;
        int half = filled + this.health % 2;
        for (int i = this.iconCount - 1; i >= 0; --i) {
            int ix = x + i % this.lineWidth * 8;
            int iy = y + i / this.lineWidth * 3;
            ctx.m_280218_(WailaHelper.GUI_ICONS_TEXTURE, ix, iy, 16, 0, 9, 9);
            if (i <= filled) {
                ctx.m_280218_(WailaHelper.GUI_ICONS_TEXTURE, ix, iy, this.absorption ? 160 : 52, 0, 9, 9);
                continue;
            }
            if (i != half) continue;
            ctx.m_280218_(WailaHelper.GUI_ICONS_TEXTURE, ix, iy, this.absorption ? 169 : 61, 0, 9, 9);
        }
    }
}

