/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.theme;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeAccessor;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.api.__internal__.IClientApiService;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Range;
import org.joml.Matrix4f;

public class GradientTheme
implements ITheme {
    public static final IThemeType<GradientTheme> TYPE = IThemeType.of(GradientTheme.class).property("backgroundColor", IntFormat.RGB_HEX, 0xFF0000).property("gradientStart", IntFormat.RGB_HEX, 65280).property("gradientEnd", IntFormat.RGB_HEX, 255).property("borderSize", true).property("borderOffset", true).property("drawCorner", false).property("fontColor", IntFormat.RGB_HEX, 0xA0A0A0).build();
    private int backgroundColor;
    private int gradientStart;
    private int gradientEnd;
    private int borderSize;
    private int borderOffset;
    private boolean drawCorner;
    private int fontColor;

    @Override
    public void processProperties(IThemeAccessor accessor) {
        this.backgroundColor = Mth.m_14045_((int)this.backgroundColor, (int)0, (int)0xFFFFFF);
        this.gradientStart = Mth.m_14045_((int)this.gradientStart, (int)0, (int)0xFFFFFF);
        this.gradientEnd = Mth.m_14045_((int)this.gradientEnd, (int)0, (int)0xFFFFFF);
        this.borderSize = Math.max(this.borderSize, 0);
        this.borderOffset = Math.max(this.borderOffset, 0);
        this.fontColor = Mth.m_14045_((int)this.fontColor, (int)0, (int)0xFFFFFF);
    }

    @Override
    public int getDefaultTextColor() {
        return this.fontColor;
    }

    @Override
    public void setPadding(ITheme.Padding padding) {
        padding.set(this.borderOffset + this.borderSize + 2);
    }

    @Override
    public void renderTooltipBackground(GuiGraphics ctx, int x, int y, int width, int height, @Range(from=0L, to=255L) int alpha, float delta) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buf = tesselator.m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = ctx.m_280168_().m_85850_().m_252922_();
        int a = alpha << 24;
        int bg = this.backgroundColor + a;
        int gradStart = this.gradientStart + a;
        int gradEnd = this.gradientEnd + a;
        int bo = this.borderOffset;
        int bo2 = this.borderOffset * 2;
        if (this.drawCorner) {
            IClientApiService.INSTANCE.fillGradient(matrix, (VertexConsumer)buf, x, y, width, height, bg, bg);
        } else {
            IClientApiService.INSTANCE.fillGradient(matrix, (VertexConsumer)buf, x + bo, y, width - bo2, height, bg, bg);
            IClientApiService.INSTANCE.fillGradient(matrix, (VertexConsumer)buf, x, y + bo, bo, height - bo2, bg, bg);
            IClientApiService.INSTANCE.fillGradient(matrix, (VertexConsumer)buf, x + width - bo, y + bo, bo, height - bo2, bg, bg);
        }
        IClientApiService.INSTANCE.renderRectBorder(matrix, (VertexConsumer)buf, x + bo, y + bo, width - bo2, height - bo2, this.borderSize, gradStart, gradEnd);
        tesselator.m_85914_();
    }
}

