/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.util.WNumbers;
import mcp.mobius.waila.api.util.WRenders;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@ApiSide.ClientOnly
public class ItemComponent
implements ITooltipComponent {
    public static final ItemComponent EMPTY = new ItemComponent(ItemStack.EMPTY);
    public final ItemStack stack;

    public ItemComponent(ItemStack stack) {
        this.stack = stack;
    }

    public ItemComponent(ItemLike item) {
        this(new ItemStack(item));
    }

    @Override
    public int getWidth() {
        return this.stack.isEmpty() ? 0 : 18;
    }

    @Override
    public int getHeight() {
        return this.stack.isEmpty() ? 0 : 18;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        ctx.renderItem(this.stack, x + 1, y + 1);
        ItemComponent.renderItemDecorations(ctx, this.stack, x + 1, y + 1);
    }

    static void renderItemDecorations(GuiGraphics ctx, ItemStack stack, int x, int y) {
        MultiBufferSource buffer = WRenders.bufferSource(ctx);
        Minecraft client = Minecraft.getInstance();
        int count = stack.getCount();
        ctx.renderItemDecorations(client.font, stack, x + 1, y + 1, "");
        if (count <= 1) {
            return;
        }
        String countText = WNumbers.suffix(count);
        int actualW = client.font.width(countText);
        float scale = actualW <= 16 ? 1.0f : 16.0f / (float)actualW;
        PoseStack pose = ctx.pose();
        pose.pushPose();
        pose.translate(0.0, 0.0, 250.0);
        pose.scale(scale, scale, 1.0f);
        Font font = client.font;
        float f = ((float)(x + 17) - (float)actualW * scale) / scale;
        float f2 = y + 17;
        Objects.requireNonNull(client.font);
        font.drawInBatch(countText, f, (f2 - 9.0f * scale) / scale, 0xFFFFFF, true, pose.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        pose.popPose();
        ctx.flush();
    }
}

