/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider.data;

import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;

public enum BeeDataProvider implements IDataProvider<Bee>
{
    INSTANCE;

    public static final IData.Type<HivePosData> HIVE_POS;
    public static final StreamCodec<RegistryFriendlyByteBuf, HivePosData> HIVE_POS_CODEC;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<Bee> accessor, IPluginConfig config) {
        BlockPos hivePos;
        if (config.getBoolean(Options.BEE_HIVE_POS) && (hivePos = accessor.getTarget().getHivePos()) != null) {
            data.addImmediate(new HivePosData(hivePos));
        }
    }

    static {
        HIVE_POS = IData.createType(ResourceLocation.withDefaultNamespace((String)"bee.hive_pos"));
        HIVE_POS_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, HivePosData::pos, HivePosData::new);
    }

    public record HivePosData(BlockPos pos) implements IData
    {
        @Override
        public IData.Type<? extends IData> type() {
            return HIVE_POS;
        }
    }
}

