/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.access;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.play.c2s.RawDataRequestContextPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.TypedDataRequestContextPlayC2SPacket;
import mcp.mobius.waila.network.play.s2c.RawDataResponsePlayS2CPacket;
import mcp.mobius.waila.network.play.s2c.TypedDataResponsePlayS2CPacket;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_8710;

public enum DataWriter implements IDataWriter
{
    SERVER(RawDataResponsePlayS2CPacket.Payload::new, TypedDataResponsePlayS2CPacket.Payload::new),
    CLIENT(RawDataRequestContextPlayC2SPacket.Payload::new, TypedDataRequestContextPlayC2SPacket.Payload::new);

    private final Function<class_2487, class_8710> rawPacket;
    private final Function<IData, class_8710> typedPacket;
    private final Map<IData.Type<IData>, IData> immediate = new HashMap<IData.Type<IData>, IData>();
    private final Map<IData.Type<IData>, List<Consumer<IDataWriter.Result<IData>>>> lazy = new HashMap<IData.Type<IData>, List<Consumer<IDataWriter.Result<IData>>>>();
    private class_2487 raw;
    private boolean clean;

    private DataWriter(Function<class_2487, class_8710> rawPacket, Function<IData, class_8710> typedPacket) {
        this.rawPacket = rawPacket;
        this.typedPacket = typedPacket;
    }

    public class_2487 reset() {
        if (this.clean) {
            return this.raw;
        }
        this.raw = new class_2487();
        this.clean = true;
        this.immediate.clear();
        this.lazy.values().forEach(List::clear);
        return this.raw;
    }

    public void send(final PacketSender sender, class_1657 player) {
        if (!this.raw.method_33133()) {
            sender.send(this.rawPacket.apply(this.raw));
        }
        this.immediate.values().forEach(data -> {
            block2: {
                try {
                    sender.send(this.typedPacket.apply((IData)data));
                }
                catch (Throwable t) {
                    if (!ExceptionUtil.dump(t, String.valueOf(data.getClass()) + "\nplayer " + player.method_5820(), null)) break block2;
                    player.method_43496((class_2561)class_2561.method_43470((String)("Error on retrieving data from provider " + data.getClass().getName())));
                }
            }
        });
        this.lazy.forEach((type, data) -> {
            final boolean[] finished = new boolean[]{false};
            for (Consumer consumer : data) {
                try {
                    consumer.accept(new IDataWriter.Result<IData>(){
                        boolean added = false;

                        @Override
                        public IDataWriter.Result<IData> add(IData data) {
                            Preconditions.checkState((!this.added ? 1 : 0) != 0, (Object)"Called multiple times in the same closure");
                            Preconditions.checkNotNull((Object)data, (Object)"Data is null");
                            sender.send(DataWriter.this.typedPacket.apply(data));
                            finished[0] = true;
                            this.added = true;
                            return this;
                        }

                        @Override
                        public IDataWriter.Result<IData> block() {
                            finished[0] = true;
                            return this;
                        }
                    });
                }
                catch (Throwable t) {
                    if (ExceptionUtil.dump(t, String.valueOf(consumer.getClass()) + "\nplayer " + player.method_5820(), null)) {
                        player.method_43496((class_2561)class_2561.method_43470((String)("Error on retrieving data from provider " + consumer.getClass().getName())));
                    }
                    finished[0] = true;
                }
                if (!finished[0]) continue;
                break;
            }
        });
    }

    @Override
    public class_2487 raw() {
        this.clean = false;
        return this.raw;
    }

    @Override
    public <D extends IData> void add(IData.Type<D> type, Consumer<IDataWriter.Result<D>> consumer) {
        this.assertType(type);
        this.clean = false;
        this.lazy.computeIfAbsent((IData.Type)TypeUtil.uncheckedCast(type), t -> new ArrayList()).add((Consumer)TypeUtil.uncheckedCast(consumer));
    }

    @Override
    public void addImmediate(IData data) {
        IData.Type<? extends IData> type = data.type();
        this.assertType(type);
        if (this.lazy.containsKey(type) && !this.lazy.get(type).isEmpty()) {
            throw new IllegalStateException("Data is already lazily added");
        }
        this.clean = false;
        this.immediate.put((IData.Type)TypeUtil.uncheckedCast(type), data);
    }

    public <P, A> void tryAppend(class_1657 player, P provider, A accessor, PluginConfig config, Provider<P, A> fn) {
        block2: {
            try {
                fn.write(provider, this, accessor, config);
            }
            catch (Throwable t) {
                if (!ExceptionUtil.dump(t, String.valueOf(provider.getClass()) + "\nplayer " + player.method_5820(), null)) break block2;
                player.method_43496((class_2561)class_2561.method_43470((String)("Error on retrieving server data from provider " + provider.getClass().getName())));
            }
        }
    }

    private void assertType(IData.Type<? extends IData> type) {
        Preconditions.checkArgument((boolean)Registrar.get().dataCodecs.containsKey(type.id()), (Object)"Data type is not registered");
        Preconditions.checkState((!this.immediate.containsKey(type) ? 1 : 0) != 0, (Object)"Data is already immediately added");
    }

    public static interface Provider<P, A> {
        public void write(P var1, DataWriter var2, A var3, PluginConfig var4);
    }
}

