/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

@ApiSide.ClientOnly
public class BarComponent
implements ITooltipComponent {
    static final int WIDTH = 100;
    static final int HEIGHT = 11;
    private static final float U0 = 22.0f;
    static final float V0_BG = 0.0f;
    private static final float V0_FG = 11.0f;
    private final float ratio;
    private final int color;
    private final Component text;

    public BarComponent(float ratio, int color) {
        this(ratio, color, CommonComponents.EMPTY);
    }

    public BarComponent(float ratio, int color, String text) {
        this(ratio, color, (Component)Component.literal((String)text));
    }

    public BarComponent(float ratio, int color, Component text) {
        this.ratio = ratio;
        this.color = color;
        this.text = text;
    }

    @Override
    public int getWidth() {
        return Math.max(Minecraft.getInstance().font.width((FormattedText)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        BarComponent.renderBar(ctx, x, y, 100, 0.0f, this.color);
        BarComponent.renderBar(ctx, x, y, (int)(100.0f * this.ratio), 11.0f, this.color);
        ctx.nextStratum();
        BarComponent.renderText(ctx, this.text, x, y);
    }

    static void renderBar(GuiGraphics ctx, int x, int y, int w, float v0, int tint) {
        ctx.blit(RenderPipelines.GUI_TEXTURED, WailaConstants.COMPONENT_TEXTURE, x, y, 22.0f, v0, w, 11, 256, 256, tint);
    }

    static void renderText(GuiGraphics ctx, Component text, int x, int y) {
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)text);
        int textX = x + (int)Math.max((float)(100 - textWidth) / 2.0f, 0.0f);
        int textY = y + 2;
        FormattedCharSequence formatted = text.getVisualOrderText();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                ctx.drawString(font, formatted, textX + i, textY + j, -14079703, false);
            }
        }
        ctx.drawString(font, formatted, textX, textY, -5592406, false);
    }
}

