/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.neo.provider;

import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.FluidData;
import mcp.mobius.waila.api.neo.NeoFluidData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public enum FluidCapabilityProvider implements IDataProvider<BlockEntity>
{
    INSTANCE;

    @Nullable
    private @Nullable BlockCapabilityCache<IFluidHandler, @Nullable Direction> cache;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BlockEntity> accessor, IPluginConfig config) {
        data.add(FluidData.TYPE, res -> {
            IFluidHandler handler;
            ServerLevel world = (ServerLevel)accessor.getWorld();
            BlockEntity target = (BlockEntity)accessor.getTarget();
            BlockPos pos = target.getBlockPos();
            if (this.cache == null || this.cache.level() != world && !this.cache.pos().equals((Object)pos)) {
                this.cache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)world, (BlockPos)pos, null);
            }
            if ((handler = (IFluidHandler)this.cache.getCapability()) == null) {
                return;
            }
            int size = handler.getTanks();
            FluidData.PlatformDependant<FluidStack> fluidData = NeoFluidData.of(size);
            for (int i = 0; i < size; ++i) {
                fluidData.add(handler.getFluidInTank(i), handler.getTankCapacity(i));
            }
            res.add(fluidData);
        });
    }
}

