/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.mixin.BeehiveBlockEntity$BeeDataAccess;
import mcp.mobius.waila.mixin.BeehiveBlockEntityAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import org.jetbrains.annotations.Nullable;

public enum BeehiveDataProvider implements IDataProvider<BeehiveBlockEntity>
{
    INSTANCE;

    public static final IData.Type<OccupantsData> OCCUPANTS;
    public static final StreamCodec<RegistryFriendlyByteBuf, OccupantsData> OCCUPANTS_CODEC;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BeehiveBlockEntity> accessor, IPluginConfig config) {
        List<BeehiveBlockEntity$BeeDataAccess> stored;
        if (config.getBoolean(Options.BEE_HIVE_OCCUPANTS) && !(stored = ((BeehiveBlockEntityAccess)accessor.getTarget()).wthit_stored()).isEmpty()) {
            ArrayList<OccupantsData.Occupant> occupants = new ArrayList<OccupantsData.Occupant>(stored.size());
            for (BeehiveBlockEntity$BeeDataAccess beeData : stored) {
                CompoundTag beeNbt = beeData.wthit_occupant().entityData().getUnsafe();
                Optional entityType = EntityType.by((CompoundTag)beeNbt);
                if (entityType.isEmpty()) continue;
                String customName = beeNbt.contains("CustomName", 8) ? beeNbt.getString("CustomName") : null;
                occupants.add(new OccupantsData.Occupant((EntityType)entityType.get(), customName));
            }
            if (!occupants.isEmpty()) {
                data.addImmediate(new OccupantsData(occupants));
            }
        }
    }

    static {
        OCCUPANTS = IData.createType(ResourceLocation.withDefaultNamespace((String)"bee.occupants"));
        OCCUPANTS_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), OccupantsData.Occupant::entityType, WailaHelper.nullable(ByteBufCodecs.STRING_UTF8), OccupantsData.Occupant::customName, OccupantsData.Occupant::new).apply(ByteBufCodecs.list()), OccupantsData::occupants, OccupantsData::new);
    }

    public record OccupantsData(List<Occupant> occupants) implements IData
    {
        @Override
        public IData.Type<? extends IData> type() {
            return OCCUPANTS;
        }

        public record Occupant(EntityType<?> entityType, @Nullable String customName) {
        }
    }
}

