/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.text.DecimalFormat;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.ArmorComponent;
import mcp.mobius.waila.api.component.HealthComponent;
import mcp.mobius.waila.api.component.PositionComponent;
import mcp.mobius.waila.api.component.SpacingComponent;
import mcp.mobius.waila.api.component.SpriteComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public enum EntityAttributesProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final ResourceLocation SPRITE_HEART;
    private static final ResourceLocation SPRITE_ARMOR;
    private static final DecimalFormat DECIMAL;

    private int addSpacing(ITooltipLine line, int i) {
        if (i > 0) {
            line.with(new SpacingComponent(3, 0));
            return i - 1;
        }
        return 0;
    }

    private void addHealth(ITooltipLine line, LivingEntity entity, CompoundTag data, boolean showAbsorption) {
        MutableComponent component = Component.literal((String)DECIMAL.format(entity.getHealth()));
        if (showAbsorption && data.contains("abs")) {
            component.append((Component)Component.literal((String)("+" + DECIMAL.format(data.getFloat("abs")))).withStyle(ChatFormatting.GOLD));
        }
        line.with(new SpriteComponent(SPRITE_HEART, 9, 9)).with((Component)component.append("/" + DECIMAL.format(entity.getMaxHealth())).withStyle(ChatFormatting.RED));
    }

    private void addArmor(ITooltipLine line, LivingEntity entity) {
        line.with(new SpriteComponent(SPRITE_ARMOR, 9, 9)).with((Component)Component.literal((String)String.valueOf(entity.getArmorValue())));
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object t = accessor.getEntity();
        if (!(t instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)t;
        boolean compact = config.getBoolean(Options.ENTITY_COMPACT);
        boolean showHealth = config.getBoolean(Options.ENTITY_HEALTH);
        boolean showAbsorption = config.getBoolean(Options.ENTITY_ABSORPTION);
        boolean showArmor = config.getBoolean(Options.ENTITY_ARMOR) && entity.getArmorValue() > 0;
        CompoundTag data = accessor.getData().raw();
        if (compact) {
            ITooltipLine line = tooltip.setLine(Options.ENTITY_COMPACT);
            int i = 0;
            if (showHealth) {
                i = this.addSpacing(line, i);
                this.addHealth(line, entity, data, showAbsorption);
                ++i;
            }
            if (showArmor) {
                i = this.addSpacing(line, i);
                this.addArmor(line, entity);
                ++i;
            }
        } else {
            ITooltipLine line;
            int maxPerLine = config.getInt(Options.ENTITY_ICON_PER_LINE);
            if (showHealth) {
                float absorption;
                line = tooltip.setLine(Options.ENTITY_HEALTH);
                float f = absorption = data.contains("abs") ? data.getFloat("abs") : 0.0f;
                if (entity.getMaxHealth() + absorption > (float)config.getInt(Options.ENTITY_LONG_HEALTH_MAX)) {
                    this.addHealth(line, entity, data, showAbsorption);
                } else {
                    line.with(new HealthComponent(entity.getHealth(), entity.getMaxHealth(), maxPerLine, false));
                    if (showAbsorption && absorption > 0.0f) {
                        line.with(new HealthComponent(absorption, 0.0f, maxPerLine, true));
                    }
                }
            }
            if (showArmor) {
                line = tooltip.setLine(Options.ENTITY_ARMOR);
                if (entity.getArmorValue() > config.getInt(Options.ENTITY_LONG_ARMOR_MAX)) {
                    this.addArmor(line, entity);
                } else {
                    line.with(new ArmorComponent(entity.getArmorValue(), maxPerLine));
                }
            }
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.ENTITY_POSITION)) {
            tooltip.setLine(Options.ENTITY_POSITION, new PositionComponent((Position)accessor.getEntity().position()));
        }
    }

    static {
        SPRITE_HEART = ResourceLocation.withDefaultNamespace((String)"hud/heart/full");
        SPRITE_ARMOR = ResourceLocation.withDefaultNamespace((String)"hud/armor_full");
        DECIMAL = new DecimalFormat("0.##");
    }
}

