/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.gui.hud.ComponentRenderer;
import mcp.mobius.waila.gui.hud.InspectComponent;
import mcp.mobius.waila.gui.hud.TooltipHandler;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.screen.YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen;
import mcp.mobius.waila.util.Log;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class InspectorScreen
extends YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen {
    private static final Log LOG = Log.create();
    private static final String API_COMPONENTS = "mcp.mobius.waila.api.component.";
    private static final Component TITLE = Component.translatable((String)"gui.waila.inspector.title");
    private static final State STATE = new State();
    private final Renderer renderer = new Renderer();
    private boolean tickSuccess = false;
    private final List<ITooltipComponent> hoveredComponent = new ArrayList<ITooltipComponent>();

    public InspectorScreen() {
        super(TITLE);
    }

    @Override
    protected void init() {
        super.init();
        InspectComponent.wrap = true;
        this.tickSuccess = TooltipHandler.tick(STATE, true);
        InspectComponent.wrap = false;
    }

    public void onClose() {
        super.onClose();
        TooltipHandler.tick();
    }

    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float tickDelta) {
        super.render(ctx, mouseX, mouseY, tickDelta);
        if (!this.hoveredComponent.isEmpty()) {
            String tag;
            String clazz;
            Objects.requireNonNull(this.minecraft.font);
            int h = 9 + 2;
            ITooltipComponent component = this.hoveredComponent.getFirst();
            if (component instanceof InspectComponent) {
                InspectComponent wrapper = (InspectComponent)component;
                component = wrapper.actual;
            }
            if ((clazz = component.getClass().getName()).startsWith(API_COMPONENTS)) {
                clazz = clazz.substring(API_COMPONENTS.length());
            }
            ctx.drawString(this.minecraft.font, (Component)Component.literal((String)clazz), 5, 5, -1);
            int y = 1;
            InspectComponent wrapper = (InspectComponent)this.hoveredComponent.getLast();
            String string = tag = wrapper.tag == null ? null : wrapper.tag.toString();
            if (tag != null) {
                ctx.drawString(this.minecraft.font, (Component)Component.translatable((String)"gui.waila.inspector.tag", (Object[])new Object[]{tag}), 5, 5 + h * y++, -1);
            }
            String provider = wrapper.origin.instance().getClass().getName();
            ctx.drawString(this.minecraft.font, (Component)Component.translatable((String)"gui.waila.inspector.provider", (Object[])new Object[]{provider}), 5, 5 + h * y++, -1);
            String pluginId = wrapper.origin.plugin().getPluginId().toString();
            ctx.drawString(this.minecraft.font, (Component)Component.translatable((String)"gui.waila.inspector.plugin_id", (Object[])new Object[]{pluginId}), 5, 5 + h * y++, -1);
            IModInfo mod = wrapper.origin.plugin().getModInfo();
            ctx.drawString(this.minecraft.font, (Component)Component.translatable((String)"gui.waila.inspector.mod", (Object[])new Object[]{mod.getName(), mod.getId()}), 5, 5 + h * y, -1);
        }
        if (this.tickSuccess) {
            this.renderer.mouseX = mouseX;
            this.renderer.mouseY = mouseY;
            this.hoveredComponent.clear();
            ComponentRenderer.set(this.renderer);
            TooltipRenderer.render(ctx, this.minecraft.getDeltaTracker());
            ComponentRenderer.set(null);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubled) {
        if (!this.hoveredComponent.isEmpty()) {
            String tag;
            StringBuilder sb = new StringBuilder();
            InspectComponent wrapper = (InspectComponent)this.hoveredComponent.getLast();
            String string = tag = wrapper.tag == null ? null : wrapper.tag.toString();
            if (tag != null) {
                sb.append("tag: ").append(tag).append("\n\t");
            }
            String provider = wrapper.origin.instance().getClass().getName();
            sb.append("provider: ").append(provider).append("\n\t");
            String pluginId = wrapper.origin.plugin().getPluginId().toString();
            sb.append("pluginId: ").append(pluginId).append("\n\t");
            IModInfo mod = wrapper.origin.plugin().getModInfo();
            sb.append("modName: ").append(mod.getName()).append("\n\t");
            sb.append("modId: ").append(mod.getId());
            LOG.info(sb.toString());
        }
        return super.mouseClicked(event, doubled);
    }

    private class Renderer
    extends ComponentRenderer {
        int mouseX;
        int mouseY;

        private Renderer() {
        }

        @Override
        public void render(GuiGraphics ctx, ITooltipComponent component, int x, int y, int cw, int ch, DeltaTracker delta) {
            component.render(ctx, x, y, delta);
            float v = 0.3f;
            if (x < this.mouseX && this.mouseX < x + cw && y < this.mouseY && this.mouseY < y + ch) {
                InspectorScreen.this.hoveredComponent.add(component);
                v = 1.0f;
            }
            ComponentRenderer.Default.renderBounds(ctx, x, y, cw, ch, v);
        }
    }

    private static class State
    implements TooltipRenderer.State {
        private State() {
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 0;
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return true;
        }

        @Override
        public int getFps() {
            return 0;
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return IWailaConfig.Overlay.Position.Align.Y.MIDDLE;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return IWailaConfig.Overlay.Position.Align.Y.MIDDLE;
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }

        @Override
        public int getBackgroundAlpha() {
            return 255;
        }

        @Override
        public ITheme getTheme() {
            return Waila.CONFIG.get().getOverlay().getColor().getTheme();
        }
    }
}

