/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.data;

import java.util.ArrayList;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.data.ProgressData;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ProgressDataImpl
extends ProgressData {
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgressDataImpl> CODEC = StreamCodec.ofMember((d, buf) -> {
        buf.writeBoolean(d.hasTick);
        if (d.hasTick) {
            buf.writeVarInt(d.currentTick);
            buf.writeVarInt(d.maxTick);
        } else {
            buf.writeFloat(d.ratio);
        }
        buf.writeVarInt(d.input.size());
        for (ItemStack stack : d.input) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)stack);
        }
        buf.writeVarInt(d.output.size());
        for (ItemStack stack : d.output) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)stack);
        }
    }, buf -> {
        boolean hasTick = buf.readBoolean();
        ProgressDataImpl d = hasTick ? new ProgressDataImpl(buf.readVarInt(), buf.readVarInt()) : new ProgressDataImpl(buf.readFloat());
        int inputSize = buf.readVarInt();
        d.input.ensureCapacity(inputSize);
        for (int i = 0; i < inputSize; ++i) {
            d.input.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(buf));
        }
        int outputSize = buf.readVarInt();
        d.output.ensureCapacity(outputSize);
        for (int i = 0; i < outputSize; ++i) {
            d.output.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(buf));
        }
        return d;
    });
    public final boolean hasTick;
    public float ratio;
    public int currentTick;
    public int maxTick;

    public ProgressDataImpl(float ratio) {
        this.hasTick = false;
        this.ratio = ratio;
    }

    public ProgressDataImpl(int currentTick, int maxTick) {
        this.hasTick = true;
        this.currentTick = currentTick;
        this.maxTick = maxTick;
    }

    public ArrayList<ItemStack> input() {
        return this.input;
    }

    public ArrayList<ItemStack> output() {
        return this.output;
    }

    @Override
    public IData.Type<? extends IData> type() {
        return TYPE;
    }
}

