/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.mcless.config;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import mcp.mobius.waila.mcless.json5.Json5Writer;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigIo<T> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    private final Consumer<String> warn;
    private final BiConsumer<String, Throwable> error;
    private final boolean json5;
    private final Supplier<Function<List<String>, @Nullable String>> commenter;
    private final Gson gson;
    private final Type type;
    private final Supplier<T> factory;
    private final int currentVersion;
    private final ToIntFunction<T> versionGetter;
    private final ObjIntConsumer<T> versionSetter;

    public ConfigIo(Consumer<String> warn, BiConsumer<String, Throwable> error, boolean json5, Supplier<Function<List<String>, @Nullable String>> commenter, Gson gson, Type type, Supplier<T> factory, int currentVersion, ToIntFunction<T> versionGetter, ObjIntConsumer<T> versionSetter) {
        this.warn = warn;
        this.error = error;
        this.json5 = json5;
        this.commenter = commenter;
        this.gson = gson;
        this.type = type;
        this.factory = factory;
        this.currentVersion = currentVersion;
        this.versionGetter = versionGetter;
        this.versionSetter = versionSetter;
    }

    public ConfigIo(Consumer<String> warn, BiConsumer<String, Throwable> error, boolean json5, Supplier<Function<List<String>, @Nullable String>> commenter, Gson gson, Type type, Supplier<T> factory) {
        this(warn, error, json5, commenter, gson, type, factory, 0, t -> 0, (a, b) -> {});
    }

    public boolean migrateJson5(Path path) {
        Path jsonPath;
        if (!this.json5) {
            return false;
        }
        String pathString = path.toString();
        if (FilenameUtils.getExtension((String)pathString).equals("json5") && Files.exists(jsonPath = path.resolveSibling(FilenameUtils.getBaseName((String)pathString) + ".json"), new LinkOption[0])) {
            try {
                Files.copy(jsonPath, path, new CopyOption[0]);
                Files.delete(jsonPath);
                this.warn.accept("Migrated from " + String.valueOf(jsonPath) + " to " + String.valueOf(path));
                return true;
            }
            catch (IOException e) {
                this.error.accept("Failed to move " + String.valueOf(jsonPath) + " to " + String.valueOf(path), e);
            }
        }
        return false;
    }

    public T read(Path path) {
        Object config;
        boolean init = true;
        if (!Files.exists(path, new LinkOption[0])) {
            if (this.migrateJson5(path)) {
                return this.read(path);
            }
            Path parent = path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.error.accept("Failed to make directory " + String.valueOf(parent), e);
                }
            }
            config = this.factory.get();
        } else {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                JsonReader jsonReader = this.gson.newJsonReader((Reader)reader);
                jsonReader.setLenient(true);
                config = this.gson.fromJson(jsonReader, this.type);
                int version = this.versionGetter.applyAsInt(config);
                if (version != this.currentVersion) {
                    Path old = Paths.get(String.valueOf(path) + "_" + DATE_FORMAT.format(new Date()), new String[0]);
                    this.warn.accept("Config file " + String.valueOf(path) + " contains different version (" + version + ") than required version (" + this.currentVersion + "), this config will be reset. Old config will be placed at " + String.valueOf(old));
                    Files.deleteIfExists(old);
                    Files.copy(path, old, new CopyOption[0]);
                    config = this.factory.get();
                } else {
                    init = false;
                }
            }
            catch (Exception e) {
                Path old = Paths.get(String.valueOf(path) + "_" + DATE_FORMAT.format(new Date()), new String[0]);
                this.error.accept("Exception when reading config file " + String.valueOf(path) + ", this config will be reset. Old config will be placed at " + String.valueOf(old), e);
                try {
                    Files.deleteIfExists(old);
                    Files.copy(path, old, new CopyOption[0]);
                }
                catch (IOException e1) {
                    this.error.accept("well this is embarrassing...", e1);
                }
                config = this.factory.get();
            }
        }
        if (init) {
            this.versionSetter.accept(config, this.currentVersion);
            this.write(path, config);
            config = this.read(path);
            this.write(path, config);
        }
        return config;
    }

    public boolean write(Path path, T value) {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            try {
                this.gson.toJson(value, this.type, (JsonWriter)(this.json5 ? new Json5Writer(writer, this.commenter.get()) : this.gson.newJsonWriter((Writer)writer)));
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.error.accept("Exception when writing config file " + String.valueOf(path), e);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }
}

