/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.Objects;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.mixin.MultiPlayerGameModeAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_636;
import net.minecraft.class_757;

public enum BreakProgressProvider implements IEventListener
{
    INSTANCE;

    boolean wasBreaking = false;
    float progressDelayTimer = 0.0f;
    float lastProgress = 0.0f;
    float lastTargetProgress = 0.0f;

    @Override
    public void onAfterTooltipRender(class_4587 matrices, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        boolean isInDelay;
        if (!config.getBoolean(Options.BREAKING_PROGRESS)) {
            return;
        }
        class_636 gameMode = Objects.requireNonNull(class_310.method_1551().field_1761);
        MultiPlayerGameModeAccess gameModeAccess = (MultiPlayerGameModeAccess)gameMode;
        float dt = class_310.method_1551().method_1534();
        boolean isBreaking = gameMode.method_2923();
        float targetProgress = gameModeAccess.wthit_destroyProgress();
        if (!isBreaking && this.wasBreaking && this.progressDelayTimer <= 0.0f) {
            this.progressDelayTimer = 4.0f;
        }
        boolean bl = isInDelay = this.progressDelayTimer > 0.0f;
        if (isInDelay) {
            targetProgress = gameModeAccess.wthit_destroyDelay() > 0 ? 1.0f : this.lastTargetProgress;
        }
        float progressDiff = targetProgress - this.lastProgress;
        float progressChangeAmount = progressDiff * dt;
        float actualProgress = class_3532.method_15363((float)(this.lastProgress + progressChangeAmount), (float)0.0f, (float)1.0f);
        float lineLength = config.getBoolean(Options.BREAKING_PROGRESS_BOTTOM_ONLY) ? (float)(rect.width - 2) * actualProgress : (float)((rect.width + rect.height - 4) * 2) * actualProgress;
        if (lineLength > 0.0f) {
            int hLength = rect.width - 2;
            int vLength = rect.height - 4;
            int x = rect.x + 1;
            int y = rect.y + rect.height - 2;
            class_289 tesselator = class_289.method_1348();
            class_287 buffer = tesselator.method_1349();
            RenderSystem.enableBlend();
            RenderSystem.disableTexture();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(class_757::method_34540);
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            int color = config.getInt(Options.BREAKING_PROGRESS_COLOR);
            this.fill(matrices, buffer, x, y, (float)x + Math.min(lineLength, (float)hLength), y + 1, color);
            lineLength -= (float)hLength;
            if (lineLength > 0.0f) {
                x = rect.x + rect.width - 2;
                y = rect.y + rect.height - 2;
                this.fill(matrices, buffer, x, y, x + 1, (float)y - Math.min(lineLength, (float)vLength), color);
                lineLength -= (float)vLength;
                if (lineLength > 0.0f) {
                    x = rect.x + rect.width - 1;
                    y = rect.y + 1;
                    this.fill(matrices, buffer, x, y, (float)x - Math.min(lineLength, (float)hLength), y + 1, color);
                    lineLength -= (float)hLength;
                    if (lineLength > 0.0f) {
                        x = rect.x + 1;
                        y = rect.y + 2;
                        this.fill(matrices, buffer, x, y, x + 1, (float)y + Math.min(lineLength, (float)vLength), color);
                    }
                }
            }
            tesselator.method_1350();
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
        }
        this.wasBreaking = isBreaking;
        this.lastProgress = actualProgress;
        this.lastTargetProgress = targetProgress;
        if (isInDelay) {
            this.progressDelayTimer -= dt;
        }
    }

    private void fill(class_4587 matrices, class_287 vertexConsumer, float x1, float y1, float x2, float y2, int color) {
        float o;
        class_1159 matrix4f = matrices.method_23760().method_23761();
        if (x1 < x2) {
            o = x1;
            x1 = x2;
            x2 = o;
        }
        if (y1 < y2) {
            o = y1;
            y1 = y2;
            y2 = o;
        }
        vertexConsumer.method_22918(matrix4f, x1, y1, 0.0f).method_39415(color).method_1344();
        vertexConsumer.method_22918(matrix4f, x1, y2, 0.0f).method_39415(color).method_1344();
        vertexConsumer.method_22918(matrix4f, x2, y2, 0.0f).method_39415(color).method_1344();
        vertexConsumer.method_22918(matrix4f, x2, y1, 0.0f).method_39415(color).method_1344();
    }
}

