/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.util.function.Function;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.vanilla.provider.ItemEntityProvider;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_7923;
import net.minecraft.class_9461;
import org.jetbrains.annotations.Nullable;

public enum ItemHolderProvider implements IEntityComponentProvider
{
    ITEM_FRAME(accessor -> ((class_1533)accessor.getEntity()).method_6940()),
    OMINOUS_ITEM_SPAWNER(accessor -> ((class_9461)accessor.getEntity()).method_58640());

    final Function<IEntityAccessor, class_1799> getter;

    private ItemHolderProvider(Function<IEntityAccessor, class_1799> getter) {
        this.getter = getter;
    }

    @Override
    @Nullable
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        class_1799 stack = this.getter.apply(accessor);
        return stack.method_7960() ? null : new ItemComponent(stack);
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_1799 stack = this.getter.apply(accessor);
        if (!stack.method_7960()) {
            IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
            tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(stack.method_7964()));
            if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
                tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(class_7923.field_41178.method_10221((Object)stack.method_7909())));
            }
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_1799 stack = this.getter.apply(accessor);
        ItemEntityProvider.appendBookProperties(tooltip, stack, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_1799 stack = this.getter.apply(accessor);
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME) && !stack.method_7960()) {
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(stack).getName()));
        }
    }
}

