/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IClientRegistrar;
import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.plugin.extra.config.ExtraBlacklistConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public abstract class DataProvider<A extends IData, I extends A>
implements IBlockComponentProvider,
IEntityComponentProvider {
    public static final Map<class_2960, DataProvider<?, ?>> INSTANCES = new HashMap();
    private final class_2960 id;
    private final Class<A> apiType;
    private final Class<I> implType;
    private final IData.Serializer<I> serializer;
    protected final class_2960 enabledBlockOption;
    protected final class_2960 enabledEntityOption;
    protected final IJsonConfig<ExtraBlacklistConfig> blacklistConfig;

    protected DataProvider(class_2960 id, Class<A> apiType, Class<I> implType, IData.Serializer<I> serializer) {
        this.id = id;
        this.apiType = apiType;
        this.implType = implType;
        this.serializer = serializer;
        this.enabledBlockOption = this.createConfigKey("enabled_block");
        this.enabledEntityOption = this.createConfigKey("enabled_entity");
        class_2960 tagId = new class_2960("waila", "extra/" + id.method_12832() + "_blacklist");
        this.blacklistConfig = IJsonConfig.of(ExtraBlacklistConfig.class).file("waila/extra/" + id.method_12832() + "_blacklist").json5().commenter(() -> ExtraBlacklistConfig.commenter(tagId)).gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ExtraBlacklistConfig.class, (Object)new ExtraBlacklistConfig.Adapter(tagId)).create()).build();
        this.blacklistConfig.save();
        INSTANCES.put(id, this);
    }

    public void register(ICommonRegistrar registrar, int priority) {
        registrar.featureConfig(this.enabledBlockOption, false);
        registrar.featureConfig(this.enabledEntityOption, false);
        this.registerAdditions(registrar, priority);
        registrar.externalConfig(this.createConfigKey("blacklist"), this.blacklistConfig.getPath());
        registrar.dataType(this.id, this.apiType, this.implType, this.serializer);
        registrar.blockData(new BlockDataProvider(), class_2586.class, 0);
        registrar.entityData(new EntityDataProvider(), class_1297.class, 0);
    }

    public void register(IClientRegistrar registrar, int priority) {
        this.registerAdditions(registrar, priority);
        registrar.body(this, class_2586.class, priority);
        registrar.body(this, class_1297.class, priority);
    }

    protected final class_2960 createConfigKey(String path) {
        return new class_2960("wailax", this.id.method_12832() + "." + path);
    }

    protected void registerAdditions(ICommonRegistrar registrar, int priority) {
    }

    protected void registerAdditions(IClientRegistrar registrar, int priority) {
    }

    protected abstract void appendBody(ITooltip var1, I var2, IPluginConfig var3, class_2960 var4);

    protected void appendBody(ITooltip tooltip, IDataReader reader, IPluginConfig config, class_2960 objectId) {
        A data = reader.get(this.apiType);
        if (data == null) {
            return;
        }
        this.appendBody(tooltip, data, config, objectId);
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(this.enabledBlockOption)) {
            return;
        }
        if (this.blacklistConfig.get().getView().blockFilter.matches(accessor.getBlock())) {
            return;
        }
        class_2591 blockEntityType = ((class_2586)Objects.requireNonNull(accessor.getBlockEntity())).method_11017();
        if (this.blacklistConfig.get().getView().blockEntityFilter.matches(blockEntityType)) {
            return;
        }
        class_2960 blockEntityId = Objects.requireNonNull(class_2378.field_11137.method_10221((Object)blockEntityType));
        this.appendBody(tooltip, accessor.getData(), config, blockEntityId);
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(this.enabledEntityOption)) {
            return;
        }
        class_1299 entityType = accessor.getEntity().method_5864();
        if (this.blacklistConfig.get().getView().entityFilter.matches(entityType)) {
            return;
        }
        this.appendBody(tooltip, accessor.getData(), config, class_2378.field_11145.method_10221((Object)entityType));
    }

    private class BlockDataProvider
    implements IDataProvider<class_2586> {
        private BlockDataProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<class_2586> accessor, IPluginConfig config) {
            class_2586 target = accessor.getTarget();
            class_2680 state = target.method_11010();
            class_2591 blockEntityType = target.method_11017();
            if (!config.getBoolean(DataProvider.this.enabledBlockOption) || DataProvider.this.blacklistConfig.get().getView().blockFilter.matches(state.method_26204()) || DataProvider.this.blacklistConfig.get().getView().blockEntityFilter.matches(blockEntityType)) {
                data.blockAll(DataProvider.this.apiType);
            }
        }
    }

    private class EntityDataProvider
    implements IDataProvider<class_1297> {
        private EntityDataProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<class_1297> accessor, IPluginConfig config) {
            class_1299 entityType = accessor.getTarget().method_5864();
            if (!config.getBoolean(DataProvider.this.enabledEntityOption) || DataProvider.this.blacklistConfig.get().getView().entityFilter.matches(entityType)) {
                data.blockAll(DataProvider.this.apiType);
            }
        }
    }
}

