/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginLoader;
import mcp.mobius.waila.plugin.PluginSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class ForgePluginLoader
extends PluginLoader {
    private static final String WAILA_PLUGIN = WailaPlugin.class.getName();

    @Override
    protected void gatherPlugins() {
        for (IModFileInfo modFile : ModList.get().getModFiles()) {
            for (String file : PLUGIN_JSON_FILES) {
                Path path = modFile.getFile().findResource(new String[]{file});
                if (!Files.exists(path, new LinkOption[0])) continue;
                this.readPluginsJson(((IModInfo)modFile.getMods().get(0)).getModId(), path);
            }
            for (ModFileScanData.AnnotationData annotation : modFile.getFile().getScanResult().getAnnotations()) {
                if (!annotation.annotationType().getClassName().equals(WAILA_PLUGIN)) continue;
                String id = (String)annotation.annotationData().get("id");
                String[] required = annotation.annotationData().getOrDefault("required", new String[0]);
                PluginSide side = switch (annotation.annotationData().getOrDefault("side", IPluginInfo.Side.BOTH)) {
                    default -> throw new MatchException(null, null);
                    case IPluginInfo.Side.CLIENT -> PluginSide.CLIENT;
                    case IPluginInfo.Side.SERVER -> PluginSide.DEDICATED_SERVER;
                    case IPluginInfo.Side.BOTH -> PluginSide.COMMON;
                };
                boolean satisfied = true;
                for (String dep : required) {
                    satisfied = satisfied && ModList.get().isLoaded(dep);
                }
                if (side == PluginSide.CLIENT && FMLLoader.getDist() != Dist.CLIENT) {
                    satisfied = false;
                }
                if (side == PluginSide.DEDICATED_SERVER && FMLLoader.getDist() != Dist.DEDICATED_SERVER) {
                    satisfied = false;
                }
                if (!satisfied) continue;
                PluginInfo.registerDeprecated(((IModInfo)modFile.getMods().get(0)).getModId(), id, side, annotation.memberName(), Arrays.asList(required), true, true);
            }
        }
    }
}

