/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentRenderer {
    private static final Random RANDOM = new Random();
    @Nullable
    private static ComponentRenderer current = null;

    public abstract void render(GuiGraphics var1, ITooltipComponent var2, int var3, int var4, int var5, int var6, DeltaTracker var7);

    public static ComponentRenderer get() {
        if (current == null) {
            current = Default.INSTANCE;
        }
        return current;
    }

    public static void set(@Nullable ComponentRenderer value) {
        if (value == null) {
            value = Default.INSTANCE;
        }
        current = value;
    }

    public static class Default
    extends ComponentRenderer {
        public static final Default INSTANCE = new Default();

        @Override
        public void render(GuiGraphics ctx, ITooltipComponent component, int x, int y, int cw, int ch, DeltaTracker delta) {
            component.render(ctx, x, y, delta);
            if (WailaClient.showComponentBounds) {
                Default.renderBounds(ctx, x, y, cw, ch, 1.0f);
            }
        }

        public static void renderBounds(GuiGraphics ctx, int x, int y, int cw, int ch, float v) {
            ctx.pose().pushPose();
            float scale = (float)Minecraft.getInstance().getWindow().getGuiScale();
            ctx.pose().scale(1.0f / scale, 1.0f / scale, 1.0f);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            int bx = Mth.floor((double)((double)((float)x * scale) + 0.5));
            int by = Mth.floor((double)((double)((float)y * scale) + 0.5));
            int bw = Mth.floor((double)((double)((float)cw * scale) + 0.5));
            int bh = Mth.floor((double)((double)((float)ch * scale) + 0.5));
            int color = -16777216 + Mth.hsvToRgb((float)RANDOM.nextFloat(), (float)RANDOM.nextFloat(), (float)v);
            DisplayUtil.renderRectBorder(ctx.pose().last().pose(), (VertexConsumer)buf, bx, by, bw, bh, 1, color, color);
            BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
            ctx.pose().popPose();
        }
    }
}

