/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mcp.mobius.waila.gui.screen.CreditsScreen;
import mcp.mobius.waila.gui.screen.PluginConfigScreen;
import mcp.mobius.waila.gui.screen.PluginToggleScreen;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.mixin.TabNavigationBarAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public interface TabbedScreen {
    public static final Supplier<List<Tab<?>>> TABS = () -> List.of(new Tab<WailaConfigScreen>(WailaConfigScreen.TITLE, WailaConfigScreen.class, WailaConfigScreen::new), new Tab<PluginToggleScreen>(PluginToggleScreen.TITLE, PluginToggleScreen.class, PluginToggleScreen::new), new Tab<PluginConfigScreen>(PluginConfigScreen.TITLE, PluginConfigScreen.class, PluginConfigScreen::new), new Tab<CreditsScreen>(CreditsScreen.TITLE, CreditsScreen.class, CreditsScreen::new));

    public static TabNavigationBar bar(Tab<?> ... tabs) {
        TabManager manager = new TabManager(t -> {}, t -> {});
        manager.setTabArea(new ScreenRectangle(0, 0, 0, 0));
        return TabNavigationBar.builder((TabManager)manager, (int)tabs.length).addTabs((net.minecraft.client.gui.components.tabs.Tab[])tabs).build();
    }

    public Screen getParent();

    default public void changeTab(Runnable change) {
        change.run();
    }

    default public void initBar(int width, Consumer<TabNavigationBar> addRenderableWidget, Consumer<TabButton> setInitialFocus) {
        Class<?> clazz = this.getClass();
        List<Tab<?>> tabs = TABS.get();
        TabNavigationBar bar = TabbedScreen.bar(tabs.toArray(new Tab[0]));
        Tab currentTab = tabs.stream().map(it -> it).filter(it -> it.clazz == clazz).findFirst().orElse(null);
        bar.setWidth(width);
        bar.arrangeElements();
        addRenderableWidget.accept(bar);
        if (currentTab != null) {
            bar.selectTab(tabs.indexOf(currentTab), false);
            setInitialFocus.accept(((TabNavigationBarAccess)bar).wthit_currentTabButton());
        }
    }

    public record Tab<T extends Screen>(Component title, Class<T> clazz, Function<Screen, T> ctor) implements net.minecraft.client.gui.components.tabs.Tab
    {
        public Component getTabTitle() {
            return this.title;
        }

        public void visitChildren(Consumer<AbstractWidget> consumer) {
        }

        public void doLayout(ScreenRectangle screenRectangle) {
            Minecraft client = Minecraft.getInstance();
            Screen parent = client.screen;
            if (parent != null && parent.getClass() == this.clazz) {
                return;
            }
            if (parent instanceof TabbedScreen) {
                TabbedScreen tabbed = (TabbedScreen)parent;
                tabbed.changeTab(() -> client.setScreen((Screen)this.ctor.apply(tabbed.getParent())));
            } else {
                client.setScreen((Screen)this.ctor.apply(parent));
            }
        }
    }
}

