/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.ItemListComponent;
import mcp.mobius.waila.api.component.NamedItemListComponent;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.api.data.ProgressData;
import mcp.mobius.waila.plugin.extra.data.ItemDataImpl;
import mcp.mobius.waila.plugin.extra.data.ProgressDataImpl;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import mcp.mobius.waila.plugin.extra.provider.ProgressProvider;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemProvider
extends DataProvider<ItemData, ItemDataImpl> {
    public static final ItemProvider INSTANCE = new ItemProvider();
    @Nullable
    private ItemData lastData = null;
    @Nullable
    private ITooltipComponent lastItemsComponent = null;

    protected ItemProvider() {
        super(ItemData.TYPE, ItemDataImpl.CODEC);
    }

    @Override
    protected void registerAdditions(ICommonRegistrar registrar, int priority) {
        registrar.syncedConfig(ItemData.CONFIG_SYNC_NBT, true, false);
        registrar.localConfig(ItemData.CONFIG_DISPLAY_MODE, ItemData.ItemDisplayMode.DYNAMIC);
        registrar.localConfig(ItemData.CONFIG_MAX_HEIGHT, 3);
        registrar.localConfig(ItemData.CONFIG_SORT_BY_COUNT, true);
        registrar.localConfig(ItemData.CONFIG_GRID_MODE_SCALE, 1.0);
    }

    @Override
    protected void appendBody(ITooltip tooltip, IDataReader reader, IPluginConfig config, ResourceLocation objectId) {
        ProgressDataImpl progress = (ProgressDataImpl)reader.get(ProgressData.TYPE);
        if (progress == null || !progress.hasTick && progress.ratio == 0.0f || progress.hasTick && progress.currentTick == 0 || ProgressProvider.isProgressOnly(progress, config)) {
            super.appendBody(tooltip, reader, config, objectId);
        }
    }

    @Override
    protected void appendBody(ITooltip tooltip, ItemDataImpl data, IPluginConfig config, ResourceLocation objectId) {
        if (data == this.lastData) {
            if (this.lastItemsComponent != null) {
                tooltip.setLine(ItemData.ID, this.lastItemsComponent);
            }
            return;
        }
        this.lastData = data;
        this.lastItemsComponent = null;
        LinkedHashMap<Object, ItemStack> merged = new LinkedHashMap<Object, ItemStack>();
        HashMap<Item, Set> unique = new HashMap<Item, Set>();
        for (ItemStack stack : data.items()) {
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            int count = stack.getCount();
            if (!data.syncNbt()) {
                if (unique.put(item, Set.of()) != null) {
                    ((ItemStack)merged.get(item)).grow(count);
                    continue;
                }
                merged.put(item, stack.copy());
                continue;
            }
            DataComponentPatch nbt = stack.getComponentsPatch();
            if (unique.computeIfAbsent(item, i -> new HashSet()).add(nbt)) {
                merged.put(new ItemWithNbt(item, nbt), stack.copy());
                continue;
            }
            ((ItemStack)merged.get(new ItemWithNbt(item, nbt))).grow(count);
        }
        if (merged.isEmpty()) {
            return;
        }
        Stream<Object> stream = merged.values().stream();
        if (config.getBoolean(ItemData.CONFIG_SORT_BY_COUNT)) {
            stream = stream.sorted(Comparator.comparingInt(ItemStack::getCount).reversed());
        }
        List<ItemStack> list = stream.toList();
        int maxHeight = config.getInt(ItemData.CONFIG_MAX_HEIGHT);
        float scale = (float)config.getDouble(ItemData.CONFIG_GRID_MODE_SCALE);
        this.lastItemsComponent = switch ((ItemData.ItemDisplayMode)((Object)config.getEnum(ItemData.CONFIG_DISPLAY_MODE))) {
            default -> throw new MatchException(null, null);
            case ItemData.ItemDisplayMode.DYNAMIC -> {
                if (list.size() <= maxHeight) {
                    yield new NamedItemListComponent(list, maxHeight);
                }
                yield new ItemListComponent(list, maxHeight, scale);
            }
            case ItemData.ItemDisplayMode.GRID -> new ItemListComponent(list, maxHeight, scale);
            case ItemData.ItemDisplayMode.LIST -> new NamedItemListComponent(list, maxHeight);
        };
        tooltip.setLine(ItemData.ID, this.lastItemsComponent);
    }

    private record ItemWithNbt(Item item, DataComponentPatch tag) {
    }
}

