/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider.data;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ListBackedContainer;

public enum SelectableSlotContainerDataProvider implements IDataProvider<BlockEntity>
{
    SHELF(Options.SHELF_ITEMS),
    BOOKSHELF(Options.BOOK_BOOKSHELF);

    public static final IData.Type<Data> DATA;
    public static final StreamCodec<RegistryFriendlyByteBuf, Data> DATA_CODEC;
    private final ResourceLocation option;

    private SelectableSlotContainerDataProvider(ResourceLocation option) {
        this.option = option;
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BlockEntity> accessor, IPluginConfig config) {
        ListBackedContainer target = (ListBackedContainer)accessor.getTarget();
        data.blockAll(ItemData.TYPE);
        if (config.getBoolean(this.option)) {
            data.add(DATA, res -> res.add(new Data((List<ItemStack>)target.getItems())));
        }
    }

    static {
        DATA = IData.createType(ResourceLocation.withDefaultNamespace((String)"chiseled_bookshelf"));
        DATA_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC), Data::items, Data::new);
    }

    public record Data(List<ItemStack> items) implements IData
    {
        @Override
        public IData.Type<? extends IData> type() {
            return DATA;
        }
    }
}

