/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import com.google.common.base.Preconditions;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.class_1058;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class FluidData
implements IData {
    public static final class_2960 ID = BuiltinDataUtil.rl("fluid");
    public static final class_2960 CONFIG_DISPLAY_UNIT = BuiltinDataUtil.rl("fluid.display_unit");

    @ApiSide.ClientOnly
    public static <T extends class_3611> void describeFluid(T fluid, FluidDescriptor<T> descriptor) {
        if (fluid instanceof class_3609) {
            class_3609 flowing = (class_3609)fluid;
            Preconditions.checkArgument((flowing == flowing.method_15751() ? 1 : 0) != 0, (Object)"Not a source fluid");
        }
        IExtraService.INSTANCE.setFluidDescFor(fluid, descriptor);
    }

    @ApiSide.ClientOnly
    public static <T extends class_3611> void describeFluid(Class<T> clazz, FluidDescriptor<T> descriptor) {
        IExtraService.INSTANCE.setFluidDescFor(clazz, descriptor);
    }

    public static void describeCauldron(class_2248 block, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(block, descriptor);
    }

    public static void describeCauldron(Class<? extends class_2248> clazz, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(clazz, descriptor);
    }

    public static FluidData of(Unit unit) {
        return IExtraService.INSTANCE.createFluidData(null, unit, -1);
    }

    public static FluidData of(Unit unit, int slotCountHint) {
        return IExtraService.INSTANCE.createFluidData(null, unit, slotCountHint);
    }

    public static <S> PlatformDependant<S> of(PlatformTranslator<S> translator) {
        return IExtraService.INSTANCE.createFluidData(translator, translator.unit(), -1);
    }

    public static <S> PlatformDependant<S> of(PlatformTranslator<S> translator, int slotCountHint) {
        return IExtraService.INSTANCE.createFluidData(translator, translator.unit(), slotCountHint);
    }

    public FluidData add(class_3611 fluid, @Nullable class_2487 nbt, double stored, double capacity) {
        class_3611 class_36112;
        capacity = Math.max(capacity, 0.0);
        stored = class_3532.method_15350((double)stored, (double)0.0, (double)capacity);
        if (capacity == 0.0) {
            capacity = Double.POSITIVE_INFINITY;
        }
        if (fluid instanceof class_3609) {
            class_3609 flowing = (class_3609)fluid;
            class_36112 = flowing.method_15751();
        } else {
            class_36112 = fluid;
        }
        class_3611 source = class_36112;
        this.implAdd(source, nbt, stored, capacity);
        return this;
    }

    protected abstract PlatformTranslator<Object> translator();

    protected abstract void implAdd(class_3611 var1, @Nullable class_2487 var2, double var3, double var5);

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static FluidData of() {
        return FluidData.of(Unit.MILLIBUCKETS);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static FluidData of(int slotCountHint) {
        return FluidData.of(Unit.MILLIBUCKETS, slotCountHint);
    }

    @ApiSide.ClientOnly
    @ApiStatus.OverrideOnly
    public static interface FluidDescriptor<T extends class_3611> {
        public void describeFluid(FluidDescriptionContext<T> var1, FluidDescription var2);
    }

    @ApiStatus.OverrideOnly
    public static interface CauldronDescriptor {
        @Nullable
        public FluidData getCauldronFluidData(class_2680 var1);
    }

    @ApiStatus.Experimental
    @ApiStatus.OverrideOnly
    public static interface PlatformTranslator<T> {
        public Unit unit();

        public class_3611 fluid(T var1);

        @Nullable
        public class_2487 nbt(T var1);

        public double amount(T var1) throws UnsupportedOperationException;
    }

    public static enum Unit {
        MILLIBUCKETS("mB"),
        DROPLETS("dp");

        public final String symbol;

        public static double convert(Unit from, Unit to, double amount) {
            if (from == to) {
                return amount;
            }
            return switch (to) {
                default -> throw new IncompatibleClassChangeError();
                case MILLIBUCKETS -> amount / 81.0;
                case DROPLETS -> amount * 81.0;
            };
        }

        private Unit(String symbol) {
            this.symbol = symbol;
        }
    }

    @ApiStatus.NonExtendable
    public static abstract class PlatformDependant<T>
    extends FluidData {
        public PlatformDependant<T> add(T stack, double capacity) {
            PlatformTranslator<Object> translator = this.translator();
            return this.add(translator.fluid(stack), translator.nbt(stack), translator.amount(stack), capacity);
        }

        public PlatformDependant<T> add(T variant, double stored, double capacity) {
            PlatformTranslator<Object> translator = this.translator();
            return this.add(translator.fluid(variant), translator.nbt(variant), stored, capacity);
        }

        @Override
        public PlatformDependant<T> add(class_3611 fluid, @Nullable class_2487 nbt, double stored, double capacity) {
            super.add(fluid, nbt, stored, capacity);
            return this;
        }
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescriptionContext<T extends class_3611> {
        public T fluid();

        @Nullable
        public class_2487 nbt();
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescription {
        public FluidDescription name(class_2561 var1);

        public FluidDescription sprite(class_1058 var1);

        public FluidDescription tint(int var1);
    }
}

