/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.IllegalFormatException;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_5253;

public final class DisplayUtil
extends class_332 {
    private static final class_310 CLIENT = class_310.method_1551();

    public static void renderStack(int x, int y, class_1799 stack) {
        DisplayUtil.renderStack(x, y, stack, stack.method_7947() > 1 ? WailaHelper.suffix(stack.method_7947()) : "");
    }

    public static void renderStack(int x, int y, class_1799 stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.method_1480().method_4010(stack, x, y);
            CLIENT.method_1480().method_4022(DisplayUtil.CLIENT.field_1772, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionUtil.dump(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void enable3DRender() {
        class_308.method_24211();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        class_308.method_24210();
        RenderSystem.disableDepthTest();
    }

    public static void renderRectBorder(class_1159 matrix, class_4588 buf, int x, int y, int w, int h, int s, int gradStart, int gradEnd) {
        if (s <= 0) {
            return;
        }
        DisplayUtil.fillGradient(matrix, buf, x, y, w, s, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x, y + h - s, w, s, gradEnd, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x, y + s, s, h - s * 2, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + w - s, y + s, s, h - s * 2, gradStart, gradEnd);
    }

    public static void fillGradient(class_1159 matrix, class_4588 buf, int x, int y, int w, int h, int start, int end) {
        float sa = (float)class_5253.class_5254.method_27762((int)start) / 255.0f;
        float sr = (float)class_5253.class_5254.method_27765((int)start) / 255.0f;
        float sg = (float)class_5253.class_5254.method_27766((int)start) / 255.0f;
        float sb = (float)class_5253.class_5254.method_27767((int)start) / 255.0f;
        float ea = (float)class_5253.class_5254.method_27762((int)end) / 255.0f;
        float er = (float)class_5253.class_5254.method_27765((int)end) / 255.0f;
        float eg = (float)class_5253.class_5254.method_27766((int)end) / 255.0f;
        float eb = (float)class_5253.class_5254.method_27767((int)end) / 255.0f;
        buf.method_22918(matrix, (float)x, (float)y, 0.0f).method_22915(sr, sg, sb, sa).method_1344();
        buf.method_22918(matrix, (float)x, (float)(y + h), 0.0f).method_22915(er, eg, eb, ea).method_1344();
        buf.method_22918(matrix, (float)(x + w), (float)(y + h), 0.0f).method_22915(er, eg, eb, ea).method_1344();
        buf.method_22918(matrix, (float)(x + w), (float)y, 0.0f).method_22915(sr, sg, sb, sa).method_1344();
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }
}

