/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.mixin.EditBoxAccess;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputValue<T>
extends ConfigValue<T, InputValue<T>> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?\\d*$");
    public static final Predicate<String> POSITIVE_INTEGER = s -> s.matches("\\d*$");
    public static final Predicate<String> DECIMAL = s -> s.matches("[-+]?\\d*([.]\\d*)?");
    public static final Predicate<String> POSITIVE_DECIMAL = s -> s.matches("\\d*([.]\\d*)?");
    public static final Predicate<String> IDENTIFIER = s -> s.matches("^[a-z\\d_./-]*$") || s.matches("^[a-z\\d_.-]*:[a-z\\d_./-]*$");
    private final Predicate<String> validator;
    private final Serializer<T> serializer;
    protected final WatchedTextfield textField;
    private boolean valueFromTextField = false;
    private boolean valueValid = true;

    public InputValue(String optionName, final T value, @Nullable T defaultValue, Consumer<T> save, Predicate<String> validator) {
        this(optionName, value, defaultValue, save, validator, new Serializer<T>(){

            @Override
            public String serialize(T t) {
                return String.valueOf(t);
            }

            @Override
            public T deserialize(String s) {
                if (value instanceof String) {
                    return s;
                }
                if (value instanceof Integer) {
                    return s.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(s);
                }
                if (value instanceof Short) {
                    return s.isEmpty() ? Short.valueOf((short)0) : Short.valueOf(s);
                }
                if (value instanceof Byte) {
                    return s.isEmpty() ? Byte.valueOf((byte)0) : Byte.valueOf(s);
                }
                if (value instanceof Long) {
                    return s.isEmpty() ? Long.valueOf(0L) : Long.valueOf(s);
                }
                if (value instanceof Double) {
                    return s.isEmpty() ? Double.valueOf(0.0) : Double.valueOf(s);
                }
                if (value instanceof Float) {
                    return s.isEmpty() ? Float.valueOf(0.0f) : Float.valueOf(s);
                }
                throw new UnsupportedOperationException("Unsupported value type");
            }
        });
    }

    public InputValue(String optionName, T value, @Nullable T defaultValue, Consumer<T> save, Predicate<String> validator, Serializer<T> serializer) {
        super(optionName, value, defaultValue, save);
        this.validator = validator;
        this.serializer = serializer;
        this.textField = new WatchedTextfield();
        this.textField.m_94144_(serializer.serialize(value));
    }

    @Override
    protected void drawValue(PoseStack matrices, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.m_94186_(!this.isDisabled());
        this.textField.m_94214_(x + width - this.textField.m_5711_());
        this.textField.f_93621_ = y + (height - this.textField.m_93694_()) / 2;
        this.textField.m_6305_(matrices, mouseX, mouseY, partialTicks);
    }

    @Override
    public void tick() {
        this.textField.m_94120_();
    }

    @NotNull
    public WatchedTextfield getListener() {
        return this.textField;
    }

    @Override
    protected void resetValue() {
        this.textField.m_94144_(this.serializer.serialize(this.defaultValue));
    }

    @Override
    public boolean isValueValid() {
        return this.valueValid;
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        super.buildSearchKey(sb);
        sb.append(" ").append(this.textField.m_94155_());
    }

    @Override
    private void setValue(String text) {
        if (!this.validator.test(text)) {
            this.valueValid = false;
            this.callWatchers();
            return;
        }
        this.valueFromTextField = true;
        try {
            this.setValue(this.serializer.deserialize(text));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.callWatchers();
    }

    @Override
    public void setValue(T value) {
        this.setValue(value, false);
        if (!this.valueFromTextField) {
            EditBoxAccess access = (EditBoxAccess)((Object)this.textField);
            access.wthit_value(this.serializer.serialize(value));
            this.textField.m_94196_(access.wthit_value().length());
            this.textField.m_94208_(this.textField.m_94207_());
            this.callWatchers();
        }
        this.valueFromTextField = false;
        this.valueValid = true;
    }

    public static interface Serializer<T> {
        public String serialize(T var1);

        public T deserialize(String var1);
    }

    public class WatchedTextfield
    extends EditBox {
        public boolean grow;

        public WatchedTextfield() {
            super(((InputValue)InputValue.this).client.f_91062_, 0, 0, 100, 18, (Component)Component.m_237119_());
            this.grow = true;
            this.m_94151_(InputValue.this::setValue);
            this.m_94199_(Integer.MAX_VALUE);
        }

        private void recalculateWidth(boolean reset) {
            if (!this.grow) {
                return;
            }
            if (reset) {
                this.m_93674_(100);
            } else {
                this.m_93674_(Mth.m_14045_((int)(((InputValue)InputValue.this).client.f_91062_.m_92895_(this.m_94155_()) + 8), (int)100, (int)300));
            }
            int cursor = this.m_94207_();
            this.m_94192_(0);
            this.m_94192_(cursor);
        }

        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
            this.recalculateWidth(!focused);
        }

        public void m_94164_(@NotNull String string) {
            String string2;
            int l;
            EditBoxAccess access = (EditBoxAccess)((Object)this);
            int i = Math.min(this.m_94207_(), access.wthit_highlightPos());
            int j = Math.max(this.m_94207_(), access.wthit_highlightPos());
            int k = access.wthit_maxLength() - this.m_94155_().length() - (i - j);
            if (k < (l = (string2 = string).length())) {
                string2 = string2.substring(0, k);
                l = k;
            }
            String string3 = new StringBuilder(this.m_94155_()).replace(i, j, string2).toString();
            if (access.wthit_filter().test(string3)) {
                access.wthit_value(string3);
                this.m_94196_(i + l);
                this.m_94208_(this.m_94207_());
                access.wthit_onValueChange(string3);
                this.recalculateWidth(false);
            }
        }
    }
}

