/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.data;

import java.util.ArrayList;
import java.util.Objects;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.data.ItemData;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemDataImpl
extends ItemData {
    private final IPluginConfig config;
    private boolean syncNbt;

    public ItemDataImpl(IPluginConfig config) {
        this.config = config;
    }

    public ItemDataImpl(FriendlyByteBuf buf) {
        this.config = null;
        this.syncNbt = buf.readBoolean();
        int size = buf.m_130242_();
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            Item item = (Item)buf.m_236816_((IdMap)Registry.f_122827_);
            int count = buf.m_130242_();
            ItemStack stack = new ItemStack((ItemLike)Objects.requireNonNull(item), count);
            if (this.syncNbt) {
                stack.m_41751_(buf.m_130260_());
            }
            this.add(stack);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        boolean syncNbt = this.config.getBoolean(CONFIG_SYNC_NBT);
        buf.writeBoolean(syncNbt);
        buf.m_130130_(this.items.size());
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            buf.m_236818_((IdMap)Registry.f_122827_, (Object)stack.m_41720_());
            buf.m_130130_(stack.m_41613_());
            if (!syncNbt) continue;
            buf.m_130079_(stack.m_41783_());
        }
    }

    public ArrayList<ItemStack> items() {
        return this.items;
    }

    public boolean syncNbt() {
        return this.syncNbt;
    }
}

