/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import java.util.List;
import mcp.mobius.waila.gui.screen.YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigScreen
extends YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen {
    private final Screen parent;
    @Nullable
    private final Runnable saver;
    @Nullable
    private final Runnable canceller;
    private boolean showEscWarning = true;
    private long lastEscPressTime = 0L;
    private int escPressed = 0;
    private final List<GuiEventListener> children = this.children();
    private ConfigListWidget options;
    protected boolean cancelled;

    public ConfigScreen(Screen parent, Component title, @Nullable Runnable saver, @Nullable Runnable canceller) {
        super(title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public ConfigScreen(Screen parent, Component title) {
        this(parent, title, null, null);
    }

    @Override
    public void init() {
        super.init();
        if (this.options == null) {
            this.options = this.getOptions();
        }
        this.options.init();
        if (this.options.enableSearchBox) {
            EditBox searchBox = this.options.getSearchBox();
            this.addWidget((GuiEventListener)searchBox);
            this.setInitialFocus((GuiEventListener)searchBox);
        }
        this.addWidget((GuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.addRenderableWidget((GuiEventListener)DisplayUtil.createButton(this.width / 2 - 102, this.height - 25, 100, 20, CommonComponents.GUI_DONE, w -> {
                if (this.options.save(false)) {
                    this.saver.run();
                    this.onClose();
                }
            }));
            this.addRenderableWidget((GuiEventListener)DisplayUtil.createButton(this.width / 2 + 2, this.height - 25, 100, 20, CommonComponents.GUI_CANCEL, w -> {
                this.cancelled = true;
                this.canceller.run();
                this.onClose();
            }));
        } else {
            this.addRenderableWidget((GuiEventListener)DisplayUtil.createButton(this.width / 2 - 50, this.height - 25, 100, 20, CommonComponents.GUI_DONE, w -> {
                if (this.options.save(false)) {
                    this.onClose();
                }
            }));
        }
    }

    protected void renderForeground(GuiGraphics ctx, int rowLeft, int rowWidth, int mouseX, int mouseY, float partialTicks) {
        ctx.drawString(this.font, this.title, rowLeft, 12, 0xFFFFFF);
    }

    public void tick() {
        this.options.tick();
    }

    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        super.render(ctx, mouseX, mouseY, partialTicks);
        this.options.render(ctx, mouseX, mouseY, partialTicks);
        if (this.options.enableSearchBox) {
            this.options.getSearchBox().render(ctx, mouseX, mouseY, partialTicks);
        }
        this.renderForeground(ctx, this.options.getRowLeft(), this.options.getRowWidth(), mouseX, mouseY, partialTicks);
        if (mouseY < 32 || mouseY > this.height - 32) {
            return;
        }
        this.options.getChildAt(mouseX, mouseY).ifPresent(element -> {
            if (element instanceof ConfigValue) {
                ConfigValue value = (ConfigValue)((Object)element);
                value.renderTooltip(ctx, mouseX, mouseY);
            }
        });
    }

    public boolean shouldCloseOnEsc() {
        if (this.showEscWarning) {
            long now = System.currentTimeMillis();
            if (now - this.lastEscPressTime > 2000L) {
                this.escPressed = 0;
            }
            this.lastEscPressTime = now;
            ++this.escPressed;
            if (this.escPressed > 5) {
                this.minecraft.getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PACK_COPY_FAILURE, (Component)Component.translatable((String)"gui.waila.esc_warning.umm"), (Component)Component.translatable((String)"gui.waila.esc_warning.lmao", (Object[])new Object[]{CommonComponents.GUI_DONE.copy().withStyle(ChatFormatting.GOLD), CommonComponents.GUI_CANCEL.copy().withStyle(ChatFormatting.DARK_PURPLE)})));
                this.showEscWarning = false;
                this.escPressed = 0;
            }
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.options.enableSearchBox && Screen.hasControlDown() && keyCode == 70) {
            this.setFocused((GuiEventListener)this.options.getSearchBox());
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.showEscWarning = true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void addListener(GuiEventListener listener) {
        this.children.add(listener);
    }

    public abstract ConfigListWidget getOptions();
}

