/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.neo.provider;

import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.ItemData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public enum ItemCapabilityProvider implements IDataProvider<BlockEntity>
{
    INSTANCE;

    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> cache;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BlockEntity> accessor, IPluginConfig config) {
        data.add(ItemData.TYPE, res -> {
            IItemHandler handler;
            ServerLevel world = (ServerLevel)accessor.getWorld();
            BlockEntity target = (BlockEntity)accessor.getTarget();
            BlockPos pos = target.getBlockPos();
            if (this.cache == null || this.cache.level() != world && !this.cache.pos().equals((Object)pos)) {
                this.cache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)world, (BlockPos)pos, null);
            }
            if ((handler = (IItemHandler)this.cache.getCapability()) == null) {
                return;
            }
            res.add(ItemData.of(config).getter(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0), handler.getSlots()));
        });
    }
}

