/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.data;

import java.util.ArrayList;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.data.ItemData;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemDataImpl
extends ItemData {
    private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> ITEM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemDataImpl> CODEC = StreamCodec.ofMember((d, buf) -> {
        boolean syncNbt = d.config.getBoolean(CONFIG_SYNC_NBT);
        buf.writeBoolean(syncNbt);
        buf.writeVarInt(d.items.size());
        for (ItemStack stack : d.items) {
            if (stack.isEmpty()) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            ITEM_CODEC.encode(buf, (Object)stack.getItemHolder());
            buf.writeVarInt(stack.getCount());
            if (!syncNbt) continue;
            DataComponentPatch.STREAM_CODEC.encode(buf, (Object)stack.getComponentsPatch());
        }
    }, buf -> {
        ItemDataImpl d = new ItemDataImpl(null);
        d.syncNbt = buf.readBoolean();
        int size = buf.readVarInt();
        d.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            Holder item = (Holder)ITEM_CODEC.decode(buf);
            int count = buf.readVarInt();
            DataComponentPatch data = d.syncNbt ? (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode(buf) : DataComponentPatch.EMPTY;
            ItemStack stack = new ItemStack(item, count, data);
            d.add(stack);
        }
        return d;
    });
    private final IPluginConfig config;
    private boolean syncNbt;

    public ItemDataImpl(IPluginConfig config) {
        this.config = config;
    }

    @Override
    public IData.Type<? extends IData> type() {
        return TYPE;
    }

    public ArrayList<ItemStack> items() {
        return this.items;
    }

    public boolean syncNbt() {
        return this.syncNbt;
    }
}

