/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.vanilla.config.EnchantmentDisplayMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public enum ItemEntityProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final ResourceLocation AUTHOR;
    private static final ResourceLocation GENERATION;
    private static long lastEnchantmentTime;
    private static int enchantmentIndex;
    private static int curseIndex;

    @Override
    @Nullable
    public Entity getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return !config.getBoolean(Options.ENTITY_ITEM_ENTITY) ? EMPTY_ENTITY : null;
    }

    @Override
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        return new ItemComponent(((ItemEntity)accessor.getEntity()).getItem());
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        ItemStack stack = ((ItemEntity)accessor.getEntity()).getItem();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(stack.getHoverName().getString()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        ItemStack stack = ((ItemEntity)accessor.getEntity()).getItem();
        ItemEntityProvider.appendBookProperties(tooltip, stack, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            String mod = IModInfo.get(((ItemEntity)accessor.getEntity()).getItem()).getName();
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(mod));
        }
    }

    public static void appendBookProperties(ITooltip tooltip, ItemStack stack, IPluginConfig config) {
        if (stack.is(Items.ENCHANTED_BOOK)) {
            EnchantmentDisplayMode mode = (EnchantmentDisplayMode)((Object)config.getEnum(Options.BOOK_ENCHANTMENT_DISPLAY_MODE));
            if (mode == EnchantmentDisplayMode.DISABLED) {
                return;
            }
            if (mode == EnchantmentDisplayMode.CYCLE) {
                EnchantmentInstance instance;
                int enchantmentTiming = config.getInt(Options.BOOK_ENCHANTMENT_CYCLE_TIMING);
                ItemEnchantments enchantmentsComponent = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                long now = System.currentTimeMillis();
                ArrayList<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
                ArrayList<EnchantmentInstance> curses = new ArrayList<EnchantmentInstance>();
                for (Object2IntMap.Entry entry : enchantmentsComponent.entrySet()) {
                    Holder enchantment = (Holder)entry.getKey();
                    int level = entry.getIntValue();
                    EnchantmentInstance instance2 = new EnchantmentInstance(enchantment, level);
                    if (enchantment.is(EnchantmentTags.CURSE)) {
                        curses.add(instance2);
                        continue;
                    }
                    enchantments.add(instance2);
                }
                if (now - lastEnchantmentTime >= (long)enchantmentTiming) {
                    lastEnchantmentTime = now;
                    ++curseIndex;
                    if (++enchantmentIndex > enchantments.size() - 1) {
                        enchantmentIndex = 0;
                    }
                    if (curseIndex > curses.size() - 1) {
                        curseIndex = 0;
                    }
                }
                Object text = null;
                if (!enchantments.isEmpty()) {
                    instance = (EnchantmentInstance)enchantments.get(enchantmentIndex);
                    text = Enchantment.getFullname((Holder)instance.enchantment(), (int)instance.level());
                }
                if (!curses.isEmpty()) {
                    instance = (EnchantmentInstance)curses.get(curseIndex);
                    Component curse = Enchantment.getFullname((Holder)instance.enchantment(), (int)instance.level());
                    text = text == null ? curse : text.copy().append(CommonComponents.NEW_LINE).append(curse);
                }
                if (text != null) {
                    tooltip.setLine(Options.BOOK_ENCHANTMENT_DISPLAY_MODE, (Component)text);
                }
            } else {
                ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                MutableComponent text = null;
                if (mode == EnchantmentDisplayMode.COMBINED) {
                    MutableComponent enchantmentLine = null;
                    MutableComponent curseLine = null;
                    for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                        Holder enchantment = (Holder)entry.getKey();
                        int level = entry.getIntValue();
                        Component name = Enchantment.getFullname((Holder)enchantment, (int)level);
                        if (enchantment.is(EnchantmentTags.CURSE)) {
                            if (curseLine == null) {
                                curseLine = Component.empty().append(name);
                                continue;
                            }
                            curseLine.append((Component)Component.literal((String)", ")).append(name);
                            continue;
                        }
                        if (enchantmentLine == null) {
                            enchantmentLine = Component.empty().append(name);
                            continue;
                        }
                        enchantmentLine.append((Component)Component.literal((String)", ")).append(name);
                    }
                    if (enchantmentLine != null) {
                        text = enchantmentLine;
                    }
                    if (curseLine != null) {
                        if (text == null) {
                            text = curseLine;
                        } else {
                            text.append(CommonComponents.NEW_LINE).append(curseLine);
                        }
                    }
                } else {
                    for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                        Component name = Enchantment.getFullname((Holder)((Holder)entry.getKey()), (int)entry.getIntValue());
                        if (text == null) {
                            text = Component.empty().append(name);
                            continue;
                        }
                        text.append(CommonComponents.NEW_LINE).append(name);
                    }
                }
                if (text != null) {
                    tooltip.setLine(Options.BOOK_ENCHANTMENT_DISPLAY_MODE, (Component)text);
                }
            }
        } else if (stack.is(Items.WRITTEN_BOOK)) {
            if (!config.getBoolean(Options.BOOK_WRITTEN)) {
                return;
            }
            WrittenBookContent tag = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
            if (tag == null) {
                return;
            }
            if (!StringUtil.isNullOrEmpty((String)tag.author())) {
                tooltip.setLine(AUTHOR, (Component)Component.translatable((String)"book.byAuthor", (Object[])new Object[]{tag.author()}));
            }
            tooltip.setLine(GENERATION, (Component)Component.translatable((String)("book.generation." + tag.generation())));
        }
    }

    static {
        AUTHOR = Options.BOOK_WRITTEN.withSuffix(".author");
        GENERATION = Options.BOOK_WRITTEN.withSuffix(".generation");
        lastEnchantmentTime = 0L;
        enchantmentIndex = 0;
        curseIndex = 0;
    }
}

