/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public enum MobTimerProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final String TIMER = "%02d:%02d";
    private long lastAge;
    private long lastDataSync;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getData().raw();
        if (data.contains("age")) {
            long minutes;
            long seconds;
            if (this.lastDataSync != accessor.getServerDataTime()) {
                this.lastDataSync = accessor.getServerDataTime();
                this.lastAge = ((Integer)data.getInt("age").orElseThrow()).intValue();
                long delay = (System.currentTimeMillis() - this.lastDataSync) / 50L;
                if (this.lastAge < 0L) {
                    this.lastAge += delay;
                } else if (this.lastAge > 0L) {
                    this.lastAge -= delay;
                }
            }
            if (this.lastAge < 0L && config.getBoolean(Options.TIMER_GROW)) {
                seconds = -this.lastAge / 20L + 1L;
                minutes = seconds / 60L;
                tooltip.setLine(Options.TIMER_GROW, new PairComponent((Component)Component.translatable((String)"tooltip.waila.timer.grow"), (Component)Component.literal((String)TIMER.formatted(minutes, seconds -= minutes * 60L))));
            }
            if (this.lastAge > 0L && config.getBoolean(Options.TIMER_BREED)) {
                seconds = this.lastAge / 20L + 1L;
                minutes = seconds / 60L;
                tooltip.setLine(Options.TIMER_BREED, new PairComponent((Component)Component.translatable((String)"tooltip.waila.timer.breed"), (Component)Component.literal((String)TIMER.formatted(minutes, seconds -= minutes * 60L))));
            }
            if (this.lastAge < 0L) {
                ++this.lastAge;
            } else if (this.lastAge > 0L) {
                --this.lastAge;
            }
        }
    }
}

