/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.service.ICommonService;
import org.apache.commons.lang3.text.WordUtils;

public final class ModInfo
implements IModInfo {
    private static final Map<String, ModInfo> CONTAINER_CACHE = new HashMap<String, ModInfo>();
    private final boolean present;
    private final String id;
    private final String name;
    private final String version;

    public ModInfo(boolean present, String id, String name, String version) {
        this.present = present;
        this.id = id;
        this.name = name;
        this.version = version;
    }

    public static void register(ModInfo info) {
        CONTAINER_CACHE.put(info.getId(), info);
    }

    public static ModInfo get(String namespace) {
        return CONTAINER_CACHE.computeIfAbsent(namespace, s -> ICommonService.INSTANCE.createModInfo((String)s).or(() -> ICommonService.INSTANCE.createModInfo(s.replace('_', '-'))).orElse(new ModInfo(false, (String)s, WordUtils.capitalizeFully((String)s.replace("_", " ")), "unknown")));
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

