/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import java.util.Objects;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.__internal__.IClientApiService;
import mcp.mobius.waila.api.component.WrappedComponent;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

@ApiSide.ClientOnly
public class PairComponent
implements ITooltipComponent {
    public final ITooltipComponent key;
    public final ITooltipComponent value;
    private int width = -1;
    private int height = -1;

    public PairComponent(Component key, Component value) {
        this(new WrappedComponent(key), new WrappedComponent(value));
    }

    public PairComponent(ITooltipComponent key, ITooltipComponent value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getWidth() {
        if (this.width == -1) {
            this.key.getWidth();
            this.width = this.getColonOffset() + this.getColonWidth() + this.value.getWidth();
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (this.height == -1) {
            this.height = Math.max(this.key.getHeight(), this.value.getHeight());
        }
        return this.height;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        int n;
        int offset = this.key.getHeight() < this.height ? (this.height - this.key.getHeight()) / 2 : 0;
        IClientApiService.INSTANCE.renderComponent(ctx, this.key, x, y + offset, delta);
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        if (9 < this.height) {
            Objects.requireNonNull(font);
            n = (this.height - 9) / 2;
        } else {
            n = 0;
        }
        offset = n;
        ctx.drawString(font, ": ", x + this.getColonOffset(), y + offset, IApiService.INSTANCE.getFontColor());
        offset = this.value.getHeight() < this.height ? (this.height - this.value.getHeight()) / 2 : 0;
        IClientApiService.INSTANCE.renderComponent(ctx, this.value, x + this.getColonOffset() + this.getColonWidth(), y + offset, delta);
    }

    private int getColonOffset() {
        return IApiService.INSTANCE.getPairComponentColonOffset();
    }

    private int getColonWidth() {
        return IApiService.INSTANCE.getColonFontWidth();
    }
}

