/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import java.util.Iterator;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IRayCastVectorProvider;
import mcp.mobius.waila.api.ITargetRedirector;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.ComponentHandler;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.RayCaster;
import mcp.mobius.waila.gui.hud.TargetRedirector;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.gui.hud.TooltipPosition;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.mixin.PlayerTabOverlayAccess;
import mcp.mobius.waila.pick.PickerResults;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ProfilerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TooltipHandler {
    private static final ConfigTooltipRendererState STATE = new ConfigTooltipRendererState();
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Component SNEAK_DETAIL = Component.translatable((String)"tooltip.waila.sneak_for_details").withStyle(ChatFormatting.ITALIC);

    public static void tick() {
        TooltipHandler.tick(STATE, false);
    }

    public static boolean tick(TooltipRenderer.State state, boolean inspect) {
        try (ProfilerUtil.Impl ignored = ProfilerUtil.profile("wthit:tick");){
            boolean bl = TooltipHandler._tick(state, inspect);
            return bl;
        }
    }

    private static boolean _tick(TooltipRenderer.State state, boolean inspect) {
        HitResult target;
        LocalPlayer player;
        TooltipHandler.STATE.render = false;
        Minecraft client = Minecraft.getInstance();
        WailaConfig.General config = Waila.CONFIG.get().getGeneral();
        if (client.level == null) {
            return false;
        }
        if (client.gameMode == null) {
            return false;
        }
        if (!inspect) {
            if (client.options.hideGui) {
                return false;
            }
            if (client.screen != null && !(client.screen instanceof ChatScreen)) {
                return false;
            }
            if (!config.isDisplayTooltip()) {
                return false;
            }
            if (config.getDisplayMode() == IWailaConfig.General.DisplayMode.HOLD_KEY && !WailaClient.keyShowOverlay.isDown()) {
                return false;
            }
            if (config.isHideFromPlayerList() && ((PlayerTabOverlayAccess)client.gui.getTabList()).wthit_isVisible()) {
                return false;
            }
            if (config.isHideFromDebug() && client.debugEntries.isF3Visible()) {
                return false;
            }
        }
        if ((player = client.player) == null) {
            return false;
        }
        Entity camera = client.getCameraEntity();
        if (camera == null) {
            return false;
        }
        float frameTime = client.getDeltaTracker().getGameTimeDeltaPartialTick(true);
        double pickRange = Math.max(player.blockInteractionRange(), player.entityInteractionRange());
        PickerResults results = PickerResults.get();
        Vec3 castOrigin = null;
        Vec3 castDirection = null;
        for (IInstanceRegistry.Entry<IRayCastVectorProvider> entry : Registrar.get().raycastVectorProviders.get(Object.class)) {
            IRayCastVectorProvider provider = entry.instance();
            if (!provider.isEnabled(PluginConfig.CLIENT)) continue;
            castOrigin = provider.getOrigin(frameTime);
            castDirection = provider.getDirection(frameTime);
            RayCaster.cast((Level)client.level, camera, castOrigin, castDirection, pickRange, results);
            break;
        }
        if (castOrigin == null) {
            return false;
        }
        Iterator<IInstanceRegistry.Entry<IRayCastVectorProvider>> iterator = results.iterator();
        while (iterator.hasNext() && TooltipHandler.processTarget(state, target = (HitResult)iterator.next(), client, (Player)player, castOrigin, castDirection, pickRange, config) != ProcessResult.BREAK) {
        }
        return true;
    }

    private static ProcessResult redirectTarget(TooltipRenderer.State state, HitResult target, TargetRedirector redirector, Minecraft client, Player player, Vec3 castOrigin, Vec3 castDirection, double pickRange, WailaConfig.General config) {
        if (redirector.nowhere) {
            return ProcessResult.BREAK;
        }
        if (redirector.behind) {
            return ProcessResult.CONTINUE;
        }
        HitResult redirect = redirector.to;
        if (redirect == null) {
            return ProcessResult.CONTINUE;
        }
        if (redirect.getType() == HitResult.Type.MISS) {
            return ProcessResult.CONTINUE;
        }
        return TooltipHandler.processTarget(state, redirect, client, player, castOrigin.subtract(target.getLocation().subtract(redirect.getLocation())), castDirection, pickRange, config);
    }

    private static ProcessResult processTarget(TooltipRenderer.State state, HitResult target, Minecraft client, Player player, Vec3 castOrigin, Vec3 castDirection, double pickRange, WailaConfig.General config) {
        ClientAccessor accessor = ClientAccessor.INSTANCE;
        accessor.set((Level)client.level, player, target, client.getCameraEntity(), castOrigin, castDirection, pickRange, client.getDeltaTracker().getGameTimeDeltaPartialTick(true));
        TooltipRenderer.beginBuild(state);
        if (target.getType() == HitResult.Type.BLOCK) {
            Block block = accessor.getBlock();
            Object blockEntity = accessor.getBlockEntity();
            TargetRedirector redirector = TargetRedirector.get();
            int redirectPriority = Integer.MAX_VALUE;
            ITargetRedirector.Result redirectResult = null;
            for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : Registrar.get().blockRedirect.get(block)) {
                redirectResult = entry.instance().redirect(redirector, accessor, PluginConfig.CLIENT);
                redirectPriority = entry.priority();
                if (redirectResult == null) continue;
                break;
            }
            boolean hasBeRedirector = false;
            for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : Registrar.get().blockRedirect.get(blockEntity)) {
                if (entry.priority() >= redirectPriority) break;
                if (!hasBeRedirector) {
                    hasBeRedirector = true;
                    redirector = TargetRedirector.get();
                }
                if ((redirectResult = entry.instance().redirect(redirector, accessor, PluginConfig.CLIENT)) == null) continue;
                break;
            }
            if (redirectResult != null && !redirector.self) {
                return TooltipHandler.redirectTarget(state, target, redirector, client, player, castOrigin, castDirection, pickRange, config);
            }
            if (block instanceof LiquidBlock ? !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID) : !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK)) {
                return ProcessResult.CONTINUE;
            }
            BlockState blockState = ComponentHandler.getOverrideBlock(target);
            if (blockState == IBlockComponentProvider.EMPTY_BLOCK_STATE) {
                return ProcessResult.CONTINUE;
            }
            accessor.setState(blockState);
            ComponentHandler.requestBlockData(accessor);
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.HEAD);
            TooltipRenderer.add(TOOLTIP);
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.BODY);
            if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.isShiftKeyDown()) {
                if (!config.isHideShiftText()) {
                    TooltipRenderer.add(new Line(null).with(SNEAK_DETAIL));
                }
            } else {
                TooltipRenderer.add(TOOLTIP);
            }
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.TAIL);
        } else if (target.getType() == HitResult.Type.ENTITY) {
            IInstanceRegistry.Entry<IEntityComponentProvider> entry;
            Object actualEntity = accessor.getEntity();
            TargetRedirector redirector = TargetRedirector.get();
            ITargetRedirector.Result redirectResult = null;
            Iterator<IInstanceRegistry.Entry<IEntityComponentProvider>> redirectPriority = Registrar.get().entityRedirect.get(actualEntity).iterator();
            while (redirectPriority.hasNext() && (redirectResult = (entry = redirectPriority.next()).instance().redirect(redirector, accessor, PluginConfig.CLIENT)) == null) {
            }
            if (redirectResult != null && !redirector.self) {
                return TooltipHandler.redirectTarget(state, target, redirector, client, player, castOrigin, castDirection, pickRange, config);
            }
            if (!PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY)) {
                return ProcessResult.CONTINUE;
            }
            if (actualEntity == null) {
                return ProcessResult.CONTINUE;
            }
            Entity targetEnt = ComponentHandler.getOverrideEntity(target);
            if (targetEnt == IEntityComponentProvider.EMPTY_ENTITY) {
                return ProcessResult.CONTINUE;
            }
            accessor.setEntity(targetEnt);
            if (targetEnt == null) {
                return ProcessResult.CONTINUE;
            }
            ComponentHandler.requestEntityData(targetEnt, accessor);
            TOOLTIP.clear();
            ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.HEAD);
            TooltipRenderer.add(TOOLTIP);
            TOOLTIP.clear();
            ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.BODY);
            if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.isShiftKeyDown()) {
                if (!config.isHideShiftText()) {
                    TooltipRenderer.add(new Line(null).with(SNEAK_DETAIL));
                }
            } else {
                TooltipRenderer.add(TOOLTIP);
            }
            TOOLTIP.clear();
            ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.TAIL);
        }
        TooltipRenderer.add(TOOLTIP);
        if (PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ICON)) {
            TooltipRenderer.setIcon(ComponentHandler.getIcon(target));
        }
        TooltipHandler.STATE.render = true;
        TooltipRenderer.endBuild();
        return ProcessResult.BREAK;
    }

    private static class ConfigTooltipRendererState
    implements TooltipRenderer.State {
        private boolean render;

        private ConfigTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return this.render;
        }

        @Override
        public boolean fireEvent() {
            return true;
        }

        private WailaConfig.Overlay getOverlay() {
            return Waila.CONFIG.get().getOverlay();
        }

        @Override
        public int getFps() {
            return this.getOverlay().getFps();
        }

        @Override
        public float getScale() {
            return this.getOverlay().getScale();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return this.getOverlay().getPosition().getAnchor().getX();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return this.getOverlay().getPosition().getAnchor().getY();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return this.getOverlay().getPosition().getAlign().getX();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return this.getOverlay().getPosition().getAlign().getY();
        }

        @Override
        public int getX() {
            return this.getOverlay().getPosition().getX();
        }

        @Override
        public int getY() {
            return this.getOverlay().getPosition().getY();
        }

        @Override
        public boolean bossBarsOverlap() {
            return this.getOverlay().getPosition().isBossBarsOverlap();
        }

        @Override
        public ITheme getTheme() {
            return this.getOverlay().getColor().getTheme();
        }

        @Override
        public int getBackgroundAlpha() {
            return this.getOverlay().getColor().getBackgroundAlpha();
        }

        @Override
        public boolean enableTextToSpeech() {
            return Waila.CONFIG.get().getGeneral().isEnableTextToSpeech();
        }
    }

    private static enum ProcessResult {
        CONTINUE,
        BREAK;

    }
}

