/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.service;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataType;
import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IRegistryFilter;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.config.JsonConfig;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.registry.InstanceRegistry;
import mcp.mobius.waila.registry.RegistryFilter;
import mcp.mobius.waila.service.MixedService;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;

public abstract class ApiService
implements IApiService {
    private static final Log LOG = Log.create();

    @Override
    public IModInfo getModInfo(ItemStack stack) {
        Item item = stack.getItem();
        if ("minecraft".equals(BuiltInRegistries.ITEM.getKey((Object)item).getNamespace())) {
            TypedEntityData customData;
            ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            if (enchantments.size() == 1) {
                Object2IntMap.Entry entry;
                ResourceKey key;
                Iterator iterator = enchantments.entrySet().iterator();
                if (iterator.hasNext() && (key = (ResourceKey)((Holder)(entry = (Object2IntMap.Entry)iterator.next()).getKey()).unwrapKey().orElse(null)) != null) {
                    return IModInfo.get(key.location());
                }
            } else if (item instanceof PotionItem || item instanceof TippedArrowItem) {
                ResourceLocation id;
                Holder potion = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().orElse(null);
                if (potion != null && (id = BuiltInRegistries.POTION.getKey((Object)((Potion)potion.value()))) != null) {
                    return IModInfo.get(id);
                }
            } else if (item instanceof SpawnEggItem && (customData = (TypedEntityData)stack.get(DataComponents.ENTITY_DATA)) != null) {
                return IModInfo.get((EntityType)customData.type());
            }
        }
        return IModInfo.get(item);
    }

    @Override
    public IBlacklistConfig getBlacklistConfig() {
        return Waila.BLACKLIST_CONFIG.get().getView();
    }

    @Override
    public <T> IJsonConfig.Builder0<T> createConfigBuilder(Type type) {
        return new JsonConfig.Builder(type);
    }

    @Override
    public IModInfo getModInfo(String namespace) {
        return ModInfo.get(namespace);
    }

    @Override
    public IPluginInfo getPluginInfo(ResourceLocation pluginId) {
        return PluginInfo.get(pluginId);
    }

    @Override
    public Collection<IPluginInfo> getAllPluginInfoFromMod(String modId) {
        return PluginInfo.getAllFromMod(modId);
    }

    @Override
    public Collection<IPluginInfo> getAllPluginInfo() {
        return PluginInfo.getAll();
    }

    @Override
    public IWailaConfig getConfig() {
        return Waila.CONFIG.get();
    }

    @Override
    public int getPairComponentColonOffset() {
        return TooltipRenderer.colonOffset;
    }

    @Override
    public int getColonFontWidth() {
        return TooltipRenderer.colonWidth;
    }

    @Override
    public int getFontColor() {
        return TooltipRenderer.state.getTheme().getDefaultTextColor() | 0xFF000000;
    }

    @Override
    public <T extends ITheme> IThemeType.Builder<T> createThemeTypeBuilder(Class<T> clazz) {
        return new ThemeType<T>(clazz);
    }

    @Override
    public String getDefaultEnergyUnit() {
        return "E";
    }

    @Override
    public Path getConfigDir() {
        return Waila.CONFIG_DIR;
    }

    @Override
    public <T> IRegistryFilter.Builder<T> createRegistryFilterBuilder(ResourceKey<? extends Registry<T>> registryKey) {
        return new RegistryFilter.Builder(registryKey);
    }

    @Override
    public <T> IInstanceRegistry<T> createInstanceRegistry(boolean reversed) {
        InstanceRegistry registry = new InstanceRegistry();
        if (reversed) {
            registry.reversed();
        }
        return registry;
    }

    @Override
    public List<ToolMaterial> getTiers() {
        return MixedService.TOOL_MATERIALS.stream().filter(it -> {
            if (it.incorrectBlocksForDrops() == null) {
                LOG.warn("Found tier of class [{}] with null inverse tag, skipping", it.getClass().getName());
                return false;
            }
            return true;
        }).sorted((tier1, tier2) -> {
            TagKey tag1 = tier1.incorrectBlocksForDrops();
            TagKey tag2 = tier2.incorrectBlocksForDrops();
            Optional opt1 = BuiltInRegistries.BLOCK.get(tag1);
            Optional opt2 = BuiltInRegistries.BLOCK.get(tag2);
            HolderSet blocks1 = opt1.isPresent() ? (HolderSet)opt1.get() : HolderSet.empty();
            HolderSet blocks2 = opt2.isPresent() ? (HolderSet)opt2.get() : HolderSet.empty();
            int size1 = blocks1.size();
            int size2 = blocks2.size();
            if (size1 == 0 && size2 == 0) {
                return 0;
            }
            if (size1 == 0) {
                return 1;
            }
            if (size2 == 0) {
                return -1;
            }
            boolean b1inB2 = blocks1.stream().allMatch(arg_0 -> ((HolderSet)blocks2).contains(arg_0));
            boolean b2inB1 = blocks2.stream().allMatch(arg_0 -> ((HolderSet)blocks1).contains(arg_0));
            if (b1inB2 && b2inB1) {
                return 0;
            }
            if (b1inB2) {
                return 1;
            }
            if (b2inB1) {
                return -1;
            }
            String blocks1str = ApiService.concatBlocks((HolderSet<Block>)blocks1);
            String blocks2str = ApiService.concatBlocks((HolderSet<Block>)blocks2);
            LOG.error("Unsolvable tier comparison!\nEither one of [{}] or [{}] does not contain all entries from the other one.\nThe comparison is based on the assumption that lower tier's incorrect block tag contains all entries from higher tier's tag.\nThis was fine for Vanilla, but might be not match modded behavior.\nPlease open an issue at {}\nTag [{}] contains:\n\t[{}]\nTag [{}] contains:\n\t[{}]\n", tag1.location(), tag2.location(), Waila.ISSUE_URL, tag1.location(), blocks1str, tag2.location(), blocks2str);
            return 0;
        }).toList();
    }

    public static String concatBlocks(HolderSet<Block> set) {
        return String.join((CharSequence)"\n\t", set.stream().map(it -> ((ResourceKey)it.unwrapKey().orElseThrow()).location().toString()).sorted().toList());
    }

    @Override
    public <D extends IData> IData.Type<D> createDataType(ResourceLocation id) {
        return new DataType(id);
    }

    @Override
    public boolean isDevEnv() {
        return Waila.DEV;
    }
}

