/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.component.NamedItemComponent;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@ApiSide.ClientOnly
public class NamedItemListComponent
implements ITooltipComponent {
    private static final String MORE = "...";
    private final List<NamedItemComponent> components;
    private final boolean hasOverflow;

    public NamedItemListComponent(List<class_1799> items, int maxHeight) {
        this.components = new ArrayList<NamedItemComponent>(Math.min(items.size(), maxHeight));
        for (int i = 0; i < items.size() && i < maxHeight; ++i) {
            this.components.add(new NamedItemComponent(items.get(i)));
        }
        this.hasOverflow = items.size() > maxHeight;
    }

    @Override
    public int getWidth() {
        int maxWidth = 0;
        for (NamedItemComponent component : this.components) {
            maxWidth = Math.max(maxWidth, component.getWidth());
        }
        if (this.hasOverflow) {
            maxWidth = Math.max(maxWidth, this.getFont().method_1727(MORE) + 10);
        }
        return maxWidth;
    }

    @Override
    public int getHeight() {
        int height = 0;
        for (NamedItemComponent component : this.components) {
            height += component.getHeight();
        }
        if (this.hasOverflow) {
            Objects.requireNonNull(this.getFont());
            height += 9;
        }
        return height;
    }

    @Override
    public void render(class_332 ctx, int x, int y, class_9779 delta) {
        int iy = y;
        for (NamedItemComponent component : this.components) {
            component.render(ctx, x, iy, delta);
            iy += component.getHeight();
        }
        if (this.hasOverflow) {
            ctx.method_25303(this.getFont(), MORE, x + 10, iy, IApiService.INSTANCE.getFontColor());
        }
    }

    private class_327 getFont() {
        return class_310.method_1551().field_1772;
    }
}

