/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.stream.Stream;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.command.ArgumentBuilderBuilder;
import mcp.mobius.waila.command.CommonCommand;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.screen.InspectorScreen;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginLoader;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public abstract class ClientCommand<S>
extends CommonCommand<S, class_310> {
    public ClientCommand() {
        super("wailac");
    }

    @Override
    protected boolean pluginCommandRequirement(S source) {
        return !class_310.method_1551().method_1496();
    }

    @Override
    protected boolean isPluginDisabledOnServer(PluginInfo plugin) {
        return plugin.isDisabledOnServer();
    }

    @Override
    protected final void register(ArgumentBuilderBuilder<S> command) {
        command.then((ArgumentBuilder<S, ?>)this.literal("config")).then((ArgumentBuilder<S, ?>)this.literal("open")).executes(context -> {
            class_310 client = class_310.method_1551();
            client.method_63588(() -> client.method_1507((class_437)new WailaConfigScreen(client.field_1755)));
            return 1;
        }).pop("open").then((ArgumentBuilder<S, ?>)this.literal("plugin")).then(this.argument("id", class_2232.method_9441())).suggests((context, builder) -> class_2172.method_9270(PluginConfig.getAllKeys(), (SuggestionsBuilder)builder)).executes(context -> {
            Object source = context.getSource();
            class_2960 id = (class_2960)context.getArgument("id", class_2960.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry == null) {
                this.fail(source, (class_2561)class_2561.method_43469((String)"command.waila.config.unknown_id", (Object[])new Object[]{id.toString()}));
                return 0;
            }
            this.success(source, () -> class_2561.method_43469((String)"command.waila.config.get.id", (Object[])new Object[]{id.toString()}));
            this.success(source, () -> class_2561.method_43469((String)"command.waila.config.get.synced", (Object[])new Object[]{entry.isSynced()}));
            this.success(source, () -> class_2561.method_43469((String)"command.waila.config.get.current_value", (Object[])new Object[]{entry.getValue(false).toString()}));
            this.success(source, () -> class_2561.method_43469((String)"command.waila.config.get.default_value", (Object[])new Object[]{entry.getDefaultValue().toString()}));
            if (entry.isServerRequired()) {
                this.success(source, () -> class_2561.method_43469((String)"command.waila.config.get.client_only_value", (Object[])new Object[]{entry.getClientOnlyValue().toString()}));
            }
            return 1;
        }).then(this.argument("value", StringArgumentType.word())).suggests((context, builder) -> {
            class_2960 id = (class_2960)context.getArgument("id", class_2960.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry != null) {
                if (entry.getType().equals(ConfigEntry.BOOLEAN)) {
                    return class_2172.method_9253((String[])new String[]{String.valueOf((Boolean)entry.getValue(false) == false)}, (SuggestionsBuilder)builder);
                }
                if (entry.getType().equals(ConfigEntry.ENUM)) {
                    Stream<String> suggestions = Arrays.stream(entry.getLocalValue().getClass().getEnumConstants()).filter(e -> e != entry.getLocalValue()).map(e -> ((Enum)e).name());
                    return class_2172.method_9264(suggestions, (SuggestionsBuilder)builder);
                }
            }
            return class_2172.method_9253((String[])new String[0], (SuggestionsBuilder)builder);
        }).executes(context -> {
            Object source = context.getSource();
            class_2960 id = (class_2960)context.getArgument("id", class_2960.class);
            ConfigEntry entry = PluginConfig.getEntry(id);
            if (entry == null) {
                this.fail(source, (class_2561)class_2561.method_43469((String)"command.waila.config.unknown_id", (Object[])new Object[]{id.toString()}));
                return 0;
            }
            if (entry.blocksClientEdit() && class_310.method_1551().method_1558() != null) {
                this.fail(source, (class_2561)class_2561.method_43469((String)"command.waila.config.set.synced", (Object[])new Object[]{id.toString()}));
            }
            JsonPrimitive jsonValue = new JsonPrimitive((String)context.getArgument("value", String.class));
            try {
                entry.setLocalValue(entry.getType().parser.apply((JsonElement)jsonValue, (JsonElement)entry.getDefaultValue()));
                this.success(source, () -> class_2561.method_43469((String)"command.waila.config.set.success", (Object[])new Object[]{id, entry.getLocalValue().toString()}));
                return 1;
            }
            catch (Throwable throwable) {
                this.fail(source, (class_2561)class_2561.method_43469((String)"command.waila.config.set.parse_fail", (Object[])new Object[]{throwable.getMessage()}));
                throwable.printStackTrace();
                return 0;
            }
        }).pop("value", "id", "plugin", "config").then((ArgumentBuilder<S, ?>)this.literal("overlay")).then(this.argument("enabled", BoolArgumentType.bool())).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{String.valueOf(!WailaClient.CONFIG.get().getGeneral().isDisplayTooltip())}, (SuggestionsBuilder)builder)).executes(context -> {
            Object source = context.getSource();
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            WailaClient.CONFIG.get().getGeneral().setDisplayTooltip(enabled);
            this.success(source, () -> class_2561.method_43471((String)(enabled ? "command.waila.overlay.true" : "command.waila.overlay.false")));
            return enabled ? 1 : 0;
        }).pop("enabled", "overlay");
        if (Waila.ENABLE_DEBUG_COMMAND) {
            command.then((ArgumentBuilder<S, ?>)this.literal("debug")).then((ArgumentBuilder<S, ?>)this.literal("showComponentBounds")).then(this.argument("enabled", BoolArgumentType.bool())).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{String.valueOf(!WailaClient.showComponentBounds)}, (SuggestionsBuilder)builder)).executes(context -> {
                Object source = context.getSource();
                boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
                class_310.method_1551().execute(() -> {
                    WailaClient.showComponentBounds = enabled;
                });
                this.success(source, () -> class_2561.method_43470((String)((enabled ? "En" : "Dis") + "abled component bounds")));
                return enabled ? 1 : 0;
            }).pop("enabled", "showComponentBounds").then((ArgumentBuilder<S, ?>)this.literal("showFps")).then(this.argument("enabled", BoolArgumentType.bool())).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{String.valueOf(!WailaClient.showFps)}, (SuggestionsBuilder)builder)).executes(context -> {
                Object source = context.getSource();
                boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
                class_310.method_1551().execute(() -> {
                    WailaClient.showFps = enabled;
                });
                this.success(source, () -> class_2561.method_43470((String)((enabled ? "En" : "Dis") + "abled FPS display")));
                return enabled ? 1 : 0;
            }).pop("enabled", "showFps").then((ArgumentBuilder<S, ?>)this.literal("inspect")).executes(context -> {
                class_310 client = class_310.method_1551();
                client.method_63588(() -> client.method_1507((class_437)new InspectorScreen()));
                return 1;
            }).pop("inspect").pop("debug");
        }
    }

    @Override
    protected class_310 getExecutor(S source) {
        return class_310.method_1551();
    }

    @Override
    protected void reloadPlugins(class_310 executor) {
        PluginLoader.reloadClientPlugins();
    }
}

