/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.access;

import mcp.mobius.waila.access.DataReader;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public enum ClientAccessor implements ICommonAccessor,
IBlockAccessor,
IEntityAccessor
{
    INSTANCE;

    private Level world;
    private Player player;
    private HitResult hitResult;
    private Vec3 renderingVec = null;
    private Block block = Blocks.AIR;
    private BlockState state = Blocks.AIR.defaultBlockState();
    private BlockPos pos = BlockPos.ZERO;
    private ResourceLocation blockRegistryName = BuiltInRegistries.ITEM.getDefaultKey();
    @Nullable
    private BlockEntity blockEntity;
    @Nullable
    private Entity entity;
    private long timeLastUpdate = System.currentTimeMillis();
    private ItemStack stack = ItemStack.EMPTY;
    private int updateId;
    private boolean dataAccess = true;
    private Vec3 rayCastOrigin;
    private Vec3 rayCastDirection;
    private double rayCastMaxDistance;
    private float frameTime;

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    public <T extends BlockEntity> T getBlockEntity() {
        return (T)this.blockEntity;
    }

    @Override
    public <T extends Entity> T getEntity() {
        return (T)this.entity;
    }

    public void setEntity(@Nullable Entity entity) {
        this.entity = entity;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    @Override
    public BlockHitResult getBlockHitResult() {
        return (BlockHitResult)this.hitResult;
    }

    @Override
    public EntityHitResult getEntityHitResult() {
        return (EntityHitResult)this.hitResult;
    }

    @Override
    public Vec3 getRenderingPosition() {
        return this.renderingVec;
    }

    @Override
    public IDataReader getData() {
        if (!this.dataAccess) {
            return DataReader.NOOP;
        }
        DataReader data = DataReader.CLIENT;
        if (!this.isTagCorrectBlockEntity() && !this.isTagCorrectEntity()) {
            data.reset(null);
        }
        return data;
    }

    @Override
    public long getServerDataTime() {
        CompoundTag data = this.getData().raw();
        return data.contains("WailaTime") ? data.getLong("WailaTime") : System.currentTimeMillis();
    }

    @Override
    @Nullable
    public Direction getSide() {
        return this.hitResult == null ? null : (this.hitResult.getType() == HitResult.Type.ENTITY ? null : ((BlockHitResult)this.hitResult).getDirection());
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public ResourceLocation getBlockId() {
        return this.blockRegistryName;
    }

    @Override
    public int getUpdateId() {
        return this.updateId;
    }

    @Override
    public Vec3 getRayCastOrigin() {
        return this.rayCastOrigin;
    }

    @Override
    public Vec3 getRayCastDirection() {
        return this.rayCastDirection;
    }

    @Override
    public double getRayCastMaxDistance() {
        return this.rayCastMaxDistance;
    }

    @Override
    public float getFrameTime() {
        return this.frameTime;
    }

    public void set(Level world, Player player, HitResult hit, Entity viewEntity, Vec3 rayCastOrigin, Vec3 rayCastDirection, double rayCastMaxDistance, float frameTime) {
        ++this.updateId;
        if (this.updateId == 0) {
            ++this.updateId;
        }
        this.world = world;
        this.player = player;
        this.hitResult = hit;
        this.rayCastMaxDistance = rayCastMaxDistance;
        this.rayCastOrigin = rayCastOrigin;
        this.rayCastDirection = rayCastDirection;
        this.frameTime = frameTime;
        if (this.hitResult.getType() == HitResult.Type.BLOCK) {
            this.pos = ((BlockHitResult)hit).getBlockPos();
            this.blockEntity = this.world.getBlockEntity(this.pos);
            this.entity = null;
            this.setState(world.getBlockState(this.pos));
        } else if (this.hitResult.getType() == HitResult.Type.ENTITY) {
            this.entity = ((EntityHitResult)hit).getEntity();
            this.pos = this.entity.blockPosition();
            this.blockEntity = null;
            this.setState(Blocks.AIR.defaultBlockState());
        }
        if (viewEntity != null) {
            double px = viewEntity.xo + (viewEntity.getX() - viewEntity.xo) * (double)frameTime;
            double py = viewEntity.yo + (viewEntity.getY() - viewEntity.yo) * (double)frameTime;
            double pz = viewEntity.zo + (viewEntity.getZ() - viewEntity.zo) * (double)frameTime;
            this.renderingVec = new Vec3((double)this.pos.getX() - px, (double)this.pos.getY() - py, (double)this.pos.getZ() - pz);
        }
    }

    public void setState(BlockState state) {
        this.state = state;
        this.block = state.getBlock();
        this.stack = this.block.getCloneItemStack((LevelReader)this.world, this.pos, state);
        this.blockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)this.block);
    }

    public void setDataAccess(boolean dataAccess) {
        this.dataAccess = dataAccess;
    }

    private boolean isTagCorrectBlockEntity() {
        if (this.blockEntity == null) {
            return false;
        }
        CompoundTag tag = DataReader.CLIENT.raw();
        if (tag == null) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.getInt("x");
        int y = tag.getInt("y");
        int z = tag.getInt("z");
        BlockPos hitPos = ((BlockHitResult)this.hitResult).getBlockPos();
        if (x == hitPos.getX() && y == hitPos.getY() && z == hitPos.getZ()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity() {
        if (this.entity == null) {
            return false;
        }
        CompoundTag tag = DataReader.CLIENT.raw();
        if (tag == null || !tag.contains("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.getInt("WailaEntityID");
        if (id == this.entity.getId()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

