/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.neo;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.neo.NeoServerCommand;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.plugin.PluginLoader;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;

@Mod(value="waila")
@EventBusSubscriber(modid="waila", bus=EventBusSubscriber.Bus.MOD)
public class NeoWaila
extends Waila {
    @SubscribeEvent
    static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            String[] mods;
            Packets.initServer();
            for (String mod : mods = new String[]{"minecraft", "forge", "wthit", "jei"}) {
                ModList.get().getModContainerById(mod).map(ModContainer::getModInfo).ifPresent(m -> DumpGenerator.VERSIONS.put(m.getDisplayName(), m.getVersion().toString()));
            }
        });
    }

    @SubscribeEvent
    static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> PluginLoader.INSTANCE.loadPlugins());
    }

    @EventBusSubscriber(modid="waila")
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void serverStarting(ServerStartingEvent event) {
            PluginConfig.reload();
        }

        @SubscribeEvent
        static void serverStopped(ServerStoppedEvent event) {
            NeoWaila.onServerStopped();
        }

        @SubscribeEvent
        static void tagReload(TagsUpdatedEvent event) {
            NeoWaila.onTagReload();
        }

        @SubscribeEvent
        static void registerCommands(RegisterCommandsEvent event) {
            new NeoServerCommand().register(event.getDispatcher());
        }
    }
}

