/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.provider;

import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITargetRedirector;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public enum BlockProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    @Nullable
    public ITargetRedirector.Result redirect(ITargetRedirector redirect, IBlockAccessor accessor, IPluginConfig config) {
        IBlacklistConfig blacklist = IBlacklistConfig.get();
        if (blacklist.contains(accessor.getBlock())) {
            return redirect.toBehind();
        }
        Object blockEntity = accessor.getBlockEntity();
        if (blockEntity != null && blacklist.contains((BlockEntity)blockEntity)) {
            return redirect.toBehind();
        }
        return null;
    }

    @Override
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        return new ItemComponent(accessor.getBlock().getCloneItemStack((LevelReader)accessor.getWorld(), accessor.getPosition(), accessor.getBlockState()));
    }

    @Override
    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() instanceof LiquidBlock) {
            return;
        }
        Block block = accessor.getBlock();
        CompoundTag data = accessor.getData().raw();
        MutableComponent name = block.getName();
        if (data.contains("customName")) {
            name = Component.literal((String)data.getString("customName")).append(" (").append((Component)name).append(")");
        }
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.blockName(name));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(BuiltInRegistries.BLOCK.getKey((Object)block)));
        }
    }

    @Override
    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(accessor.getBlock()).getName()));
        }
    }
}

